% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportMethods.R
\name{parseCAGEscanBlocksToGrangeTSS}
\alias{parseCAGEscanBlocksToGrangeTSS}
\title{parseCAGEscanBlocksToGrangeTSS}
\usage{
parseCAGEscanBlocksToGrangeTSS(blocks)
}
\arguments{
\item{blocks}{A character string representing a block in a CAGEscan molecule.}
}
\value{
A GRanges object representing a TSS.

In CAGEscan molecules, blocks are separated by \sQuote{|}, \sQuote{,} or
\sQuote{;} for gap of coverage, splice junction (confident) and splice
junction (maybe) respectively.  Strand is "+" if first coordinate is lower
than the second one, and "-" otherwise.
}
\description{
Parse a string describing a block in a CAGEscan molecule, as output by
the "CAGEscan 3.0" pipeline.
}
\examples{
myMolecule <- paste0( "chr11:66268633-66268693,"
                    , "chr11:66271796-66271869;"
                    , "chr11:66272156-66272252|"
                    , "chr11:66272364-66272460")
myFirstBlock <- sub("[,;|].*", "", myMolecule)

CAGEr:::parseCAGEscanBlocksToGrangeTSS(myFirstBlock)
}
\seealso{
import.CAGEscanMolecule
}
