% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Annotations.R
\name{mapStatsScopes}
\alias{mapStatsScopes}
\alias{msScope_counts}
\alias{msScope_mapped}
\alias{msScope_qc}
\alias{msScope_steps}
\alias{msScope_all}
\alias{msScope_annotation}
\title{mapStats scopes}
\usage{
msScope_counts(libs)

msScope_mapped(libs)

msScope_qc(libs)

msScope_steps(libs)

msScope_all(libs)

msScope_annotation(libs)
}
\arguments{
\item{libs}{A data frame containing metadata describing samples in sequence
libraries.}
}
\value{
Returns a list with three elements: \code{libs} contains a modified
version of the input data frame where columns have been reorganised as needed,
\code{colums} contains the names of the columns to use for plotting and
provides the order of the stacked bars of the \code{plotAnnot} function,
\code{total} indicates the total counts used for normalising the data.
}
\description{
Functions implementing the \code{scope} parameter of the
\verb{\link{mapStats}} function.
}
\details{
The \strong{\code{counts}} scope reports the number of molecules aligning in
\emph{promoter}, \emph{exon}, \emph{intron} and otherwise \emph{intergenic}.
regions.

The \strong{\code{mapped}} scope reports the number of molecules aligning in
\emph{promoter}, \emph{exon}, \emph{intron} and otherwise \emph{intergenic},
plus the number of PCR duplicates (mapped tags minus molecule counts), plus
the number of non-properly paired mapped tags.

The \strong{\code{qc}} scope reports the number of tags removed as
\emph{tag dust}, \emph{rRNA}, \emph{spikes}, plus the \emph{unmapped} tags,
plus the number of non-properly paired mapped tags, plus the number of PCR
duplicates (mapped tags minus molecule counts), plus the number of unique
molecule counts.

The \strong{\code{steps}} scope reports the number of tags removed by
\emph{cleaning}, \emph{mapping}, and \emph{deduplication}, plus the number
of \emph{unique molecule counts}.

The legacy \strong{\code{all}} scope reports the number of tags in
\emph{promoters}, \emph{exons}, \emph{introns}, or \emph{mapped} elswhere, or removed because
they match rRNA or are likely primer artefacts, normalised by the total
nubmer of extracted tags.

The legacy \strong{\code{annotation}} scope reports the number of tags in
\emph{promoters}, \emph{exons}, \emph{introns}, or \emph{mapped} elswhere, or removed because
they match rRNA or are likely primer artefacts, normalised by the total
nubmer of mapped tags.
}
