% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportMethods.R
\name{loadFileIntoGPos}
\alias{loadFileIntoGPos}
\title{loadFileIntoGPos}
\usage{
loadFileIntoGPos(
  filepath,
  filetype = c("bam", "bamPairedEnd", "bigwig", "bed", "bedScore", "bedctss",
    "CAGEscanMolecule", "ctss"),
  sequencingQualityThreshold,
  mappingQualityThreshold,
  removeFirstG,
  correctSystematicG,
  genome
)
}
\arguments{
\item{filepath}{The path to the file to load.}

\item{filetype}{The type of the file}

\item{sequencingQualityThreshold}{See getCTSS().}

\item{mappingQualityThreshold}{See getCTSS().}

\item{removeFirstG}{See getCTSS().}

\item{correctSystematicG}{See getCTSS().}

\item{genome}{See coerceInBSgenome().}
}
\value{
A \code{\link[GenomicRanges:GPos-class]{GenomicRanges::GPos()}} object where the score represents the number of CAGE tags
starting on that nucleotide.
}
\description{
A private (non-exported) function to load from each file format supported by CAGEr
}
\seealso{
import.CTSS

Other loadFileIntoGPos: 
\code{\link{bam2CTSS}()},
\code{\link{import.CTSS}()},
\code{\link{import.bam}()},
\code{\link{import.bam.ctss}()},
\code{\link{import.bedCTSS}()},
\code{\link{import.bedScore}()},
\code{\link{import.bedmolecule}()},
\code{\link{import.bigwig}()},
\code{\link{moleculesGR2CTSS}()}
}
\concept{loadFileIntoGPos}
