% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AggregationMethods.R
\name{CustomConsensusClusters}
\alias{CustomConsensusClusters}
\alias{CustomConsensusClusters,CAGEexp,GRanges-method}
\title{Expression levels of consensus cluster}
\usage{
CustomConsensusClusters(
  object,
  clusters,
  threshold = 0,
  nrPassThreshold = 1,
  thresholdIsTpm = TRUE
)

\S4method{CustomConsensusClusters}{CAGEexp,GRanges}(
  object,
  clusters,
  threshold = 0,
  nrPassThreshold = 1,
  thresholdIsTpm = TRUE
)
}
\arguments{
\item{object}{A \code{CAGEexp} object}

\item{clusters}{Consensus clusters in \code{\link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges}} format.}

\item{threshold, nrPassThreshold}{Only CTSSs with signal \verb{>= threshold} in
\verb{>= nrPassThreshold} experiments will be used for clustering and will
contribute towards total signal of the cluster.}

\item{thresholdIsTpm}{Logical, is threshold raw tag count value (FALSE) or
normalized signal (TRUE).}
}
\value{
stores the result as a new \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{SummarizedExperiment::RangedSummarizedExperiment}} in the
\code{experiment} slot of the object.  The assays of the new experiment are called
\code{counts} and \code{normalized}.  An \code{outOfClusters} column is added
to the sample metadata to reflect the number of molecules that do not have
their TSS in a consensus cluster.
}
\description{
Intersects custom consensus clusters with the CTSS data in a
\code{\link{CAGEexp}} object, and stores the result as a expression matrices
(raw and normalised tag counts).
}
\details{
Consensus clusters must not overlap, so that a single base of the
genome can only be attributed to a single cluster.  This is enforced by the
\code{\link{.ConsensusClusters}} constructor.
}
\examples{

cc <- consensusClustersGR(exampleCAGEexp)
CustomConsensusClusters(exampleCAGEexp, cc)

}
\seealso{
Other CAGEr object modifiers: 
\code{\link{CTSStoGenes}()},
\code{\link{aggregateTagClusters}()},
\code{\link{annotateCTSS}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{getCTSS}()},
\code{\link{normalizeTagCount}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{quickEnhancers}()},
\code{\link{resetCAGEexp}()},
\code{\link{summariseChrExpr}()}

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{consensusClustersDESeq2}()},
\code{\link{consensusClustersGR}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{paraclu}()},
\code{\link{plotInterquantileWidth}()},
\code{\link{quantilePositions}()},
\code{\link{tagClustersGR}()}
}
\author{
Charles Plessy
}
\concept{CAGEr clusters functions}
\concept{CAGEr object modifiers}
