% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utilsSimplifyTxDb}
\alias{utilsSimplifyTxDb}
\title{Utility: Extract annotation hierachy from a TxDb.}
\usage{
utilsSimplifyTxDb(
  object,
  tssUpstream = 100,
  tssDownstream = 100,
  proximalUpstream = 1000,
  detailedAntisense = FALSE
)
}
\arguments{
\item{object}{TxDb: Transcript database}

\item{tssUpstream}{integer: Distance to extend annotated promoter upstream.}

\item{tssDownstream}{integer: Distance to extend annotated promoter
downstream.}

\item{proximalUpstream}{integer: Maximum distance upstream of promoter to be
considered proximal.}

\item{detailedAntisense}{logical: Wether to mirror all txType categories in
the antisense direction (TRUE) or lump them all together (FALSE).}
}
\value{
GRangesList of annotation hierachy
}
\description{
Used by assignTxType. This function extracts the hierachical annotations used
by assignTxType from a TxDb object. If you are annotating many ranges, it can
be time saving to built the hierachy first, to avoid processing the TxDb for
every assignTxDb call.
}
\examples{
\dontrun{
data(exampleUnidirectional)

# Obtain transcript models from a TxDb-object:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene

# Simplify txdb
hierachy <- utilsSimplifyTxDb(txdb)

# Standard way of calling
x <- assignTxType(exampleUnidirectional,
                  txModels=txdb)

# Calling with premade hierachy
y <- assignTxType(exampleUnidirectional, txModels=hierachy)

# These are identical
stopifnot(all(rowRanges(x)$txType == rowRanges(y)$txType))
}
}
\seealso{
assignTxType

Other Utility functions: 
\code{\link{utilsAggregateRows}()},
\code{\link{utilsDeStrand}()},
\code{\link{utilsScoreOverlaps}()}
}
\concept{Utility functions}
