% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimTo.R
\name{trimToPeak}
\alias{trimToPeak}
\alias{trimToPeak,GRanges,GRanges-method}
\alias{trimToPeak,GRanges,GPos-method}
\alias{trimToPeak,RangedSummarizedExperiment,GenomicRanges-method}
\alias{trimToPeak,GRanges,RangedSummarizedExperiment-method}
\alias{trimToPeak,RangedSummarizedExperiment,RangedSummarizedExperiment-method}
\title{Trim width of TCs by distance from TC peak}
\usage{
trimToPeak(object, pooled, ...)

\S4method{trimToPeak}{GRanges,GRanges}(object, pooled, upstream, downstream)

\S4method{trimToPeak}{GRanges,GPos}(object, pooled, ...)

\S4method{trimToPeak}{RangedSummarizedExperiment,GenomicRanges}(object, pooled, ...)

\S4method{trimToPeak}{GRanges,RangedSummarizedExperiment}(object, pooled, ...)

\S4method{trimToPeak}{RangedSummarizedExperiment,RangedSummarizedExperiment}(object, pooled, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: Tag clusters.}

\item{pooled}{GenomicRanges or RangedSummarizedExperiment: Basepair-wise
pooled CTSS (stored in the score column).}

\item{...}{additional arguments passed to methods.}

\item{upstream}{integer: Maximum upstream distance from TC peak.}

\item{downstream}{integer: Maximum downstream distance from TC peak.}
}
\value{
data.frame with two columns: threshold and nTCs (number of Tag
  Clusters)
}
\description{
Trim the width of TCs by distance from the TC peaks.
}
\examples{
data(exampleCTSSs)
data(exampleBidirectional)

# Calculate pooled CTSSs
exampleCTSSs <- calcTPM(exampleCTSSs, totalTags='totalTags')
exampleCTSSs <- calcPooled(exampleCTSSs)

# Choose a few wide clusters:
TCs <- subset(exampleUnidirectional, width >= 100)

# Trim to +/- 10 bp of TC peak
trimToPeak(TCs, pooled=exampleCTSSs, upstream=10, downstream=10)
}
\seealso{
Other Clustering functions: 
\code{\link{clusterBidirectionally}()},
\code{\link{clusterUnidirectionally}()},
\code{\link{trimToPercentiles}()},
\code{\link{tuneTagClustering}()}

Other Trimming functions: 
\code{\link{trimToPercentiles}()}
}
\concept{Clustering functions}
\concept{Trimming functions}
