% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{bwCommonGenome}
\alias{bwCommonGenome}
\title{Find a common genome for a series of BigWig files.}
\usage{
bwCommonGenome(plusStrand, minusStrand, method = "intersect")
}
\arguments{
\item{plusStrand}{BigWigFileList: BigWig files with plus-strand CTSS data.}

\item{minusStrand}{BigWigFileList: BigWig files with minus-strand CTSS data.}

\item{method}{character: Either 'intersect' or 'union'.}
}
\value{
Sorted Seqinfo-object.
}
\description{
Finds a common genome for a series of BigWig-files, either using only levels
present in all files (intersect) or in any file (union).
}
\examples{
if (.Platform$OS.type != "windows") {
# Use the BigWig-files included with the package:
data('exampleDesign')
bw_plus <- system.file('extdata', exampleDesign$BigWigPlus,
                       package = 'CAGEfightR')
bw_minus <- system.file('extdata', exampleDesign$BigWigMinus,
                        package = 'CAGEfightR')

# Create two named BigWigFileList-objects:
bw_plus <- BigWigFileList(bw_plus)
bw_minus <- BigWigFileList(bw_minus)
names(bw_plus) <- exampleDesign$Name
names(bw_minus) <- exampleDesign$Name

# Find the smallest common genome (intersect) across the BigWigList-objects:
bwCommonGenome(plusStrand=bw_plus, minusStrand=bw_minus, method='intersect')

# Find the most inclusive genome (union) across the BigWigList-objects:
bwCommonGenome(plusStrand=bw_plus, minusStrand=bw_minus, method='union')
}
}
\seealso{
Other BigWig functions: 
\code{\link{bwGenomeCompatibility}()},
\code{\link{bwValid}()}
}
\concept{BigWig functions}
