% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{spatialAssociationPlot}
\alias{spatialAssociationPlot}
\title{Heatmap plot of association of scores with area labels}
\usage{
spatialAssociationPlot(
  associations,
  qval.thres = 0.01,
  absval.thres = 0,
  colors = NULL
)
}
\arguments{
\item{associations}{A statistical association data.frame generated
by the function \code{spatialAssociation}.}

\item{qval.thres}{The maximum Q-value to consider in the plot (a
L-R interaction must associate with one label at least with a Q-value
smaller or equal to this threshold).}

\item{absval.thres}{The minimum value to consider in the plot (a
L-R interaction must associate with one label at least with an absolute
value larger or equal to this threshold).}

\item{colors}{A function returning a color for a given value such as
generated by \code{circlize::colorRamp2}.}
}
\value{
ComplexHeatmap::Heatmap object
}
\description{
Plot a heatmap featuring Q-values 
or values of statistical association between
L-R interaction score spatial distributions and tissue area labels.
}
\details{
Display a heatmap linking L-R interactions to labels.
}
\examples{
data(bsrdm.spa, package = "BulkSignalR")
data(bsrinf.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")

thres <- 0.01
bsrinf.red <- reduceToBestPathway(bsrinf.spa)
s.red  <- BSRSignature(bsrinf.red, qval.thres=thres)
scores.red <- scoreLRGeneSignatures(bsrdm.spa,s.red)

# statistical association with tissue areas based on correlations

assoc.bsr.corr <- spatialAssociation(scores.red[c(1:10), ],
areas = annotation.spa, label.col = "ground_truth",test = "Spearman")

spatialAssociationPlot(assoc.bsr.corr)
}
