% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{simpleHeatmap}
\alias{simpleHeatmap}
\title{Heatmap function for LR scores}
\usage{
simpleHeatmap(
  mat.c,
  dend.row = NULL,
  dend.spl = NULL,
  cols = NULL,
  pointsize = 4,
  bottom.annotation = NULL,
  n.col.clust = 0,
  n.row.clust = 0,
  gap.size = 0.5,
  cut.p = 0.01,
  row.names = TRUE,
  column.names = TRUE,
  hcl.palette = NULL,
  reverse = FALSE
)
}
\arguments{
\item{mat.c}{A matrix with the signature scores such as output by
\code{scoreLRGeneSignatures()}.}

\item{dend.row}{A precomputed row dendrogram.}

\item{dend.spl}{A precompute sample (column) dendrogram.}

\item{cols}{A vector of colors to use for the heatmap.}

\item{pointsize}{Heatmap font point size}

\item{bottom.annotation}{\code{ComplexHeatmap} package bottom annotations.}

\item{n.col.clust}{Number of column clusters.}

\item{n.row.clust}{Number of row clusters.}

\item{gap.size}{Gap size between clusters.}

\item{cut.p}{Proportion of top and bottom values for thresholding.}

\item{row.names}{A logical to turn on/off the display of row names.}

\item{column.names}{A logical to turn on/off the display
of column (sample) names.}

\item{hcl.palette}{support for HCL colormaps in ComplexHeatmap
using color mapping function with circlize::colorRamp2().
palettes are listed in grDevides::hcl.pals().
of row (gene) names.}

\item{reverse}{A logical to reverse or not colors in hcl.palette.}
}
\value{
A heatmap. Since heatmap plotting tend to be slow on the screen,
it is advisable to plot in a file instead.

If hcl.palette is set, the colors parameter won't be used.

Extreme values (top and bottom) can be replaced by global quantiles at
\code{cut.p} and \code{1-cut.p}
to avoid color scales shrunk by a few outliers.

This is a convenience function that relies on the \code{ComplexHeatmap}
package to propose a simple way
of representing signature scores. If more advanced features are needed or
more graphic parameters
should be controlled, users should implement their own function.
}
\description{
Generate a heatmap representing ligand-receptor gene
signature scores.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")

bsrinf.redBP <- reduceToBestPathway(bsrinf)
bsrsig.redBP <- BSRSignature(bsrinf,
    qval.thres = 0.001
)

scoresLR <- scoreLRGeneSignatures(bsrdm, bsrsig.redBP,
    name.by.pathway = FALSE
)
simpleHeatmap(scoresLR[1:3, ],
    column.names = TRUE,
    hcl.palette = "Cividis")
}
