% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource.R
\name{resetPathways}
\alias{resetPathways}
\title{Import pathways from a file or data frame}
\usage{
resetPathways(
  dataframe = NULL,
  file = NULL,
  fileType = c("json", "gmt", "txt"),
  resourceName = NULL
)
}
\arguments{
\item{dataframe}{Data frame formated as follows.
When \code{resourceName} is set to "Reactome",
dataframe colnames must be defined as
"Reactome ID", "Gene name", and "Reactome name"
When \code{resourceName} is set to "GO-BP",
#' dataframe colnames must be defined as
"GO ID", "Gene name", and "GO name"}

\item{file}{Path to file.}

\item{fileType}{Default is Json.
Other options are gmt or txt files.}

\item{resourceName}{Two options "GO-BP" or "Reactome".}
}
\value{
Returns `NULL`, invisibly.
}
\description{
\code{resetPathways} is a function
we provide to users who want to refresh REACTOME
and GO-BP content included in BulkSignalR.
}
\details{
Pathways in `BulkSignalR` (as sets of genes/proteins) are defined
after Reactome and GOBP databases.
Those can be updated using
json files from
the Human Molecular Signatures Database (MSigDB)
at \url{https://www.gsea-msigdb.org/}
Gmt file format also can be imported.
A data frame can be used directly also.
}
\examples{
reactSubset <- getResource(resourceName = "Reactome",
cache = TRUE)

subset <- c("REACTOME_BASIGIN_INTERACTIONS",
"REACTOME_SYNDECAN_INTERACTIONS",
"REACTOME_ECM_PROTEOGLYCANS",
"REACTOME_CELL_JUNCTION_ORGANIZATION")

reactSubset <- reactSubset[
reactSubset$`Reactome name` \%in\% subset,]

resetPathways(dataframe = reactSubset,
resourceName = "Reactome")
}
