% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{.getCorrelatedLR}
\alias{.getCorrelatedLR}
\title{Get correlated ligand-receptor pairs}
\usage{
.getCorrelatedLR(ds, min.cor = 0.25, restrict.genes = NULL)
}
\arguments{
\item{ds}{A BSRDataModel object.}

\item{min.cor}{The minimum correlation required.}

\item{restrict.genes}{A list of gene symbols that restricts ligands and
receptors.}
}
\value{
A data frame containing putative ligand-receptor pairs along
  with their correlations above \code{min.cor}. This table is the first step
  of a ligand-receptor analysis.
}
\description{
Internal function to compute the Spearman correlations
of all the ligand-receptor
pairs in LRdb and return those above a minimum value.
}
\details{
The \code{restrict.genes} parameter is used for special cases where
  LRdb must be further restricted to a subset.
  The putative ligand-receptor pairs has 3 columns : R, L and corr.
}
\keyword{internal}
