% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulatedInference.R
\name{.downstreamRegulatedSignaling}
\alias{.downstreamRegulatedSignaling}
\title{Internal function to check receptor signaling downstream}
\usage{
.downstreamRegulatedSignaling(
  lr,
  pw,
  pw.size,
  rncounts,
  stats,
  id.col,
  gene.col,
  pw.col,
  min.positive,
  pos.targets = FALSE,
  neg.targets = FALSE,
  min.t.logFC = 0.5,
  with.complex = TRUE
)
}
\arguments{
\item{lr}{A data frame as returned by
\code{.getRegulatedLR()}.}

\item{pw}{A table defining the reference pathways.}

\item{pw.size}{A named vector with pathway sizes (names are pathway
IDs).}

\item{rncounts}{A matrix of normalized read counts with at
least all the ligands, receptors, and genes in the reference pathways.}

\item{stats}{A data.frame with a column 'pval' and
\code{rownames(stats)} assigned to gene symbols. Rows must at least
  include all the ligands, receptors, and genes in the reference pathways.}

\item{id.col}{Column index or name in \code{pw} for the pathway IDs.}

\item{gene.col}{Column index or name in \code{pw} for the gene
symbols.}

\item{pw.col}{Column index or name in \code{pw} for the pathway
names.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{pos.targets}{A logical imposing that all the network targets must
display positive logFC, i.e. logFC >= min.t.logFC.}

\item{neg.targets}{A logical imposing that all the network targets must
display negative logFC, i.e. logFC <= - min.t.logFC.}

\item{min.t.logFC}{The minimum log2 fold-change allowed for
targets in case pos.targets or neg.targets are used.}

\item{with.complex}{A logical indicating whether receptor co-complex
members should be included in the target genes.}
}
\value{
A table reporting all the ligand-receptor pairs provided in \code{lr}
  along with the pathways found and data about target gene regulation
  P-values. Note that correlations are currently set to 1 to avoid
  lengthy computations with scRNA-seq data and multiple cell
  populations.
}
\description{
Internal function to check receptor signaling downstream
}
\keyword{internal}
