% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Vis_heatmap}
\alias{Vis_heatmap}
\title{Heatmap Visualization of Gene Expression by Subtype}
\usage{
Vis_heatmap(x, out)
}
\arguments{
\item{x}{A gene expression matrix, where genes are rows and samples are
columns. The data should be log2 transformed.}

\item{out}{A data frame containing two columns: \code{"PatientID"} and
\code{"Subtype"}. The \code{"PatientID"} column should contain unique patient
identifiers, and the \code{"Subtype"} column should specify the assigned subtype
for each patient.}
}
\value{
A \code{ggplot} or \code{heatmap} object (depending on implementation)
representing the heatmap of gene expression across different subtypes.
}
\description{
This function generates a heatmap to visualize gene expression
patterns across breast cancer subtypes, based on the provided gene expression
matrix and subtype information.
}
\examples{
library(SummarizedExperiment)
data("OSLO2EMIT0obj")
res <- OSLO2EMIT0obj$res

# Prepare data: Gene expression matrix and subtype information
x <- assay(OSLO2EMIT0obj$data_input$se_NC)
out <- data.frame(
    PatientID = res$results$genefu.robust$BS.all$PatientID,
    Subtype = res$results$genefu.robust$BS.all$BS
)

# Generate the heatmap
p <- Vis_heatmap(x, out)
plot(p)

}
