% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\docType{package}
\name{BreastSubtypeR}
\alias{BreastSubtypeR}
\alias{BreastSubtypeR-package}
\title{BreastSubtypeR: A Unified R/Bioconductor Package
for Intrinsic Molecular Subtyping in Breast Cancer Research}
\description{
\strong{BreastSubtypeR} is an R/Bioconductor package that unifies multiple
published intrinsic subtyping (IS) methods for breast cancer into a single,
reproducible framework. It supports both nearest-centroid (NC-based) and
single-sample predictor (SSP-based) classifiers and introduces an
assumption-aware \strong{AUTO mode} that dynamically selects methods compatible
with the input cohort.

By standardising input handling, applying method-specific normalisation,
and providing optimised probe-to-gene mapping, BreastSubtypeR reduces
inconsistencies across platforms and improves reproducibility in translational
research. A companion Shiny app (\strong{iBreastSubtypeR}) offers an intuitive GUI
for non-programmers while preserving data privacy.
\subsection{Workflow}{
\enumerate{
\item \strong{Data Input}: Supply a gene expression dataset as a \code{SummarizedExperiment}.
Supported inputs include raw RNA-seq counts (with gene lengths),
log2(FPKM+1) RNA-seq, or log2-normalised microarray/nCounter data.
\item \strong{Gene Mapping}: Prepare expression data with \code{\link{Mapping}},
including Entrez ID-based resolution of duplicates.
\item \strong{Subtyping}: Apply multiple classifiers simultaneously using
\code{\link{BS_Multi}}, or enable \strong{AUTO mode} for
cohort-aware method selection.
\item \strong{Visualisation}: Summarise and interpret subtyping results with
\code{\link{Vis_Multi}}.
}
}

\subsection{Key Features}{
\itemize{
\item \strong{Multi-method framework}: Ten published NC- and SSP-based classifiers,
harmonised under one interface.
\item \strong{AUTO mode}: Evaluates cohort composition (e.g., ER/HER2 prevalence,
subtype purity, subgroup sizes) and disables classifiers with violated
assumptions; improves accuracy, Cohen’s kappa, and IHC concordance.
\item \strong{Standardised normalisation}: Upper-quartile log2-CPM for NC-based
methods; FPKM for SSP-based methods.
\item \strong{Optimised gene mapping}: Entrez ID-based mapping with conflict resolution.
\item \strong{Dual accessibility}: A Bioconductor-compliant R API and a local Shiny app
(iBreastSubtypeR).
}
}
}
\seealso{
\code{\link{Mapping}}, \code{\link{BS_Multi}}, \code{\link{Vis_Multi}}
}
\author{
\strong{Maintainer}: Qiao Yang \email{yq.kiuo@gmail.com} (\href{https://orcid.org/0000-0002-4098-3246}{ORCID})

Authors:
\itemize{
  \item Emmanouil G. Sifakis \email{emmanouil.sifakis@ki.se} (\href{https://orcid.org/0000-0001-9919-4471}{ORCID})
}

}
