% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\name{BS_sspbc}
\alias{BS_sspbc}
\title{Intrinsic Subtyping using SSPBC (BS_sspbc)}
\usage{
BS_sspbc(se_obj, ssp.name = "ssp.pam50")
}
\arguments{
\item{se_obj}{A \code{SummarizedExperiment} object containing:
\itemize{
\item \strong{Assay data}: A gene expression matrix with genes (Entrez IDs) as rows
and samples as columns.
\itemize{
\item Expression values must be \strong{positive} (e.g., FPKM or log2(FPKM+1)).
\item Values should not be gene-centered or globally scaled.
}
}}

\item{ssp.name}{Character. Specifies the SSPBC model to use:
\itemize{
\item \code{"ssp.pam50"}: Predicts PAM50-based intrinsic subtypes.
\item \code{"ssp.subtype"}: Predicts Prosigna-like subtypes (four subtypes, excluding Normal-like).
}}
}
\value{
A character vector of intrinsic subtype predictions for each sample,
as estimated by the SSPBC method.
}
\description{
Implements \strong{SSPBC (Single Sample Predictor for Breast Cancer)}, a
refinement of the original AIMS methodology trained on the large,
population-based SCAN-B RNA-seq cohort. SSPBC provides robust
single-sample predictions, independent of cohort composition, and supports
multiple model variants for different applications.
}
\examples{
## Example using SSPBC with the PAM50 model
data("OSLO2EMIT0obj")
res <- BS_sspbc(
    se_obj = OSLO2EMIT0obj$data_input$se_SSP,
    ssp.name = "ssp.pam50"
)

}
\references{
Staaf J, Häkkinen J, Hegardt C, Saal LH, Kimbung S, Hedenfalk I, et al.
\emph{RNA sequencing-based single sample predictors of molecular subtype and risk of recurrence for clinical assessment of early-stage breast cancer.}
NPJ Breast Cancer. 2022;8(1):27.
https://doi.org/10.1038/s41523-022-00465-3
}
