% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{AIMSmodel}
\alias{AIMSmodel}
\title{AIMSmodel: Model object for AIMS}
\format{
An object of class \code{list} of length 4.
}
\usage{
data("AIMSmodel")
}
\value{
\item{all.pairs}{Character vector of the 100 AIMS rules (EntrezID comparisons).}
\item{k}{Integer; number of optimal rules (commonly 20).}
\item{one.vs.all.tsp}{Naive Bayes classifier object used with the rules.}
\item{selected.pairs.list}{Rules ranked by discriminative power per subtype.}
}
\description{
Model definition for AIMS consisting of 100 pairwise rules and a Naive Bayes
classifier (via \pkg{e1071}) as described by Paquet & Hallett (2015).
}
\details{
The 100 rules are of the form “EntrezID gene A < EntrezID gene B”. A subset
of \code{k} rules (typically 20) is used within a Naive Bayes classifier to
assign subtypes (Basal-like, HER2-enriched, LumA, LumB, Normal-like) on a
per-sample basis.
}
\examples{
library(BreastSubtypeR)
data("AIMSmodel")
}
\references{
Paquet ER, Hallett MT.
Absolute assignment of breast cancer intrinsic molecular subtype.
\emph{J Natl Cancer Inst}. 2015;107(1):dju357. https://doi.org/10.1093/jnci/dju357
}
\keyword{datasets}
