% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping_set.R
\name{mapping_set}
\alias{mapping_set}
\alias{go_sets}
\alias{kegg_sets}
\alias{map_set}
\alias{map_add_set}
\title{Functions for mapping sets in the set tibble to different id types}
\usage{
go_sets(org, from, go = c("GO", "GOID"), evidence = NULL, ontology = NULL)

kegg_sets(species)

map_set(.data, from, to)

map_add_set(.data, org, from, add)
}
\arguments{
\item{org}{The AnnotationDbi object to identify keys/mappings from.}

\item{from}{A character to indicate which identifier to map from.}

\item{go}{A character to indicate the column name for the GO ids. 
Default is "GO".}

\item{evidence}{A character to indicate the evidence codes for GO 
associations with a gene of interest. Default is all possible evidence 
codes.}

\item{ontology}{A character to indicate which Gene Ontology to use. 
Default is BP, CC, and MF.}

\item{species}{Which species the pathways are from.}

\item{.data}{The BiocSet object that contains the set tibble being mapped.}

\item{to}{A character to indicate which identifier to map to.}

\item{add}{The id to add to the \code{BiocSet} object.}
}
\value{
For \code{go_sets}, a \code{BiocSet} object with GO ids as the set 
    ids.

For \code{kegg_sets}, a \code{BiocSet} object with Entrez IDs 
    reported as elements (default from KEGGREST) and KEGG pathways as sets.

For \code{map_set}, a BiocSet object with the mapped set present in 
    the set tibble.

For \code{map_add_set}, a \code{BiocSet} object with a new column in
    the set tibble with the mapping of the new id type.
}
\description{
Functions for creating \code{BiocSet} objects from GO sets and
    KEGG sets, and creating a new set mapping from a current \code{BiocSet} 
    object. \code{map_add_set} will add the mapping as a new column instead 
    of overwriting the current one used for the mapping.
}
\examples{
library(org.Hs.eg.db)
go <- go_sets(org.Hs.eg.db, "ENSEMBL")

kegg_sets("hsa")

es <- BiocSet(set1 = letters, set2 = LETTERS)
es \%>\% map_set("set1", "foo") 

library(GO.db)
map <- map_add_set(go, GO.db, "GOID", "DEFINITION")
go \%>\% mutate_set(definition = map)
}
