% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocFile.R
\docType{class}
\name{BiocFile-class}
\alias{BiocFile-class}
\alias{BiocFile}
\alias{BiocFileList-class}
\alias{show,BiocFile-method}
\alias{as.character,BiocFile-method}
\alias{path}
\alias{path,BiocFile-method}
\alias{resource}
\alias{resource<-}
\alias{fileFormat}
\alias{fileFormat,BiocFile-method}
\alias{fileFormat,character-method}
\alias{FileForFormat}
\alias{BiocFileList}
\alias{resource,BiocFile-method}
\alias{resource<-,BiocFile,character_OR_connection-method}
\title{BiocFile class objects}
\usage{
BiocFileList(files)

resource(x)

resource(x) <- value

\S4method{resource}{BiocFile}(x)

\S4method{resource}{BiocFile,character_OR_connection}(x) <- value

fileFormat(x)

\S4method{fileFormat}{character}(x)

\S4method{fileFormat}{BiocFile}(x)

\S4method{path}{BiocFile}(object, ...)

\S4method{show}{BiocFile}(object)

FileForFormat(path, format = file_ext(path), prefix = NULL, suffix = "File")

\S4method{as.character}{BiocFile}(x)
}
\arguments{
\item{files}{\code{character()} A vector of file paths for the \code{BiocFileList}
constructor}

\item{x}{A \code{BiocFile} instance}

\item{object}{A \code{BiocFile} instance}

\item{...}{additional arguments to lower-level functions, not used.}

\item{path, value}{Either a \code{character} or \code{connection} object to replace the
original resource}

\item{format}{\code{character(1)} The file extension conducive to a file class
name, e.g., \code{CSVFile}}

\item{prefix}{\code{character(1)} The prefix to prepend to the format class name,
e.g., \code{Spatial} for a class \code{SpatialCSV}.}

\item{suffix}{\code{character(1)} The suffix to append to the format class name,
e.g., \code{File} for a class \code{CSVFile}.}
}
\value{
For constructors, an instance of that class. For extractors such as
\code{resource} and \code{path}, typically a \code{character} vector of the file path.
For \code{FileForFormat}, a convenient instance of the class for which the
input file corresponds to.
}
\description{
\code{BiocFile} is the base virtual class for high-level file
abstractions where subclasses are associated with a particular file format
or type. It wraps a low-level representation of a file, currently either a
path, URL, or connection object. We can represent a list of \code{BiocFile}
objects with a \code{BiocFileList}.
}
\section{Accessor Methods}{

In the code snippets below, \code{x} represents a \code{BiocFile} object.
\itemize{
\item \code{path(x)}: Gets the path, as a \code{character} vector, to the resource
represented by the \code{BiocFile} object, if possible.
\item \code{resource(x)}: Gets the low-level resource, either a character vector
(a path or URL) or a connection.
\item \code{fileFormat(x)}: Gets a string identifying the file format. Can also
be called directly on a character file path, in which case it uses a
heuristic based on the file extension.
}
}

\section{FileForFormat}{

The \code{prefix} and \code{suffix} arguments are used to filter the class names to
those that match the pattern \code{paste0(prefix, format, suffix)}. If either
\code{prefix} or \code{suffix} are \code{NULL}, they are ignored. Note that the search is
case insensitive and does require the \code{format} to be in the name of the
class.
}

\examples{
## For our examples, we create a class called CSVFILE that extends BiocFile
.CSVFile <- setClass("CSVFile", contains = "BiocFile")

## Constructor
CSVFile <- function(resource) {
    .CSVFile(resource = resource)
}

setMethod("import", "CSVFile", function(con, format, text, ...) {
    read.csv(resource(con), ...)
})

## Define export
setMethod("export", c("data.frame", "CSVFile"),
    function(object, con, format, ...) {
        write.csv(object, resource(con), ...)
    }
)

## Recommend CSVFile class for .csv files
temp <- tempfile(fileext = ".csv")
FileForFormat(temp)

## Create CSVFile
csv <- CSVFile(temp)

## Display path of file
path(csv)

## Display resource of file
resource(csv)

}
\seealso{
Implementing classes include:
\link[rtracklayer:BigWigFile]{BigWigFile},
\link[rtracklayer:TwoBitFile-class]{TwoBitFile},
\link[rtracklayer:BEDFile-class]{BEDFile},
\link[rtracklayer:GFFFile-class]{GFFFile},
\link[rtracklayer:WIGFile-class]{WIGFile}
}
\author{
Michael Lawrence
}
\keyword{classes}
\keyword{methods}
