% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocCheck-class.R
\docType{class}
\name{BiocCheck-class}
\alias{BiocCheck-class}
\title{An internal class for composing BiocCheck reports}
\arguments{
\item{...}{\code{character()} A vector that makes up the \code{BiocCheck} exception
message (e.g., 'Vignette must be built by R CMD build'). The character
vector is handled with \code{paste0} and made into a list and appended with
\code{help_text} and \code{messages}.}

\item{help_text}{\code{character(1)} Additional text prompting a list of files
(e.g,. "Found in files:")}

\item{condition}{\code{character(1)} One of the three conditions handled: \code{error},
\code{warning}, or \code{note}}

\item{messages}{\code{character()} Often a vector of file names where the check
was triggered.}

\item{debug}{\code{logical(1)} Whether to append the name of the originating check
name into for trace-ability}

\item{checkName}{\code{character(1)} The title of the current group of checks. It
can be set with \code{handleCheck}, e.g.,
\code{handleCheck("Checking for version number mismatch...")}. Internally, it
'  is saved with \code{setCheck} and obtained with \code{getLastCheck}.}

\item{isOnBBS}{\code{logical(1)} Indicates whether the checks are being run on the
Bioconductor Build System (BBS). This is helpful for avoiding the creation
of folders in the BBS.}

\item{file}{\code{character(1)} A path to a JSON file for writing or reading as
created by \code{toJSON} and \code{fromJSON} \code{BiocCheck} methods.}
}
\value{
An internal \code{BiocCheck} R5 Reference Class used to document
conditions such as errors, warnings, and notes
}
\description{
The \code{BiocCheck} class provides a framework for reporting checks
based on Bioconductor guidelines. The class has several methods for working
with the provided checks that handle and display messages and the display
of the metadata. These methods also record the output of the \code{BiocCheck()}
report in both plain text and JSON formats.

\strong{Note} that currently, multiple \code{BiocCheck} runs will interfere with
each other given that they are implemented via a reference class semantic.
When running multiple checks in the same session, you can separate these
instances by running them in separate processes (e.g., via \code{BiocParallel}).
}
\details{
The metadata includes a number of standard fields to allow easier
troubleshooting and display of potentially relevant information. Currently,
the fields included are:
\itemize{
\item BiocCheckVersion:  The version of the BiocCheck package
\item BiocVersion:  The version of Bioconductor
\item Package:  The name of the package in check
\item PackageVersion:  The version of the package in check
\item sourceDir:  The directory of the package source or tarball in check
\item installDir: The directory where the package is installed for
testing, a temporary location by default
\item BiocCheckDir: The directory where the \verb{<package>.BiocCheck} folder
is saved. Usually the same folder as the package in check
\item platform:  The platform/OS where the check is taking place
\item isTarBall: Whether the package in check is a source directory or a
tarball
}
}
\section{Fields}{

\describe{
\item{\code{log}}{\code{list()} A running list of all conditions raised (i.e., notes,
warnings, errors)}

\item{\code{check}}{\code{character(1)} The title of the last check used for logging
purposes.}

\item{\code{error,warning,note}}{\code{list()} Finer extraction of each condition type}

\item{\code{metadata}}{\code{list()} A list of additional information relevant to the
package and its state. See details.}
}}

\section{methods}{

\itemize{
\item \code{add}: Include a condition to the \code{BiocCheck} report
\item \code{addMetadata}: Add metadata to the \code{BiocCheck} object from a
\code{BiocPackage} object
\item \code{getLastCheck}: Obtain the name of the last check run
\item \code{setCheck}: Create a new element in the internal list for a check
\item \code{get}: Extract the list of conditions raised by \code{BiocCheck}
\item \code{getNum}: Tally the number of condition provided by the input
\item \code{zero}: Reset the internal log of the condition provided
\item \code{getBiocCheckDir}: Report and create the \verb{<package>.BiocCheck}
directory as obtained from the metadata
\item \code{composeReport}: Simplify the list structure from the \code{log} and
provide a character vector of conditions raised
\item \code{report}: Write the \verb{00BiocCheck.log} report into the \code{BiocCheck}
folder
\item \code{toJSON}: Write a JSON file to the location indicated with the
conditions raised
\item \code{fromJSON}: Read a JSON file from the location indicated with the
output of previous conditions raised in the check
\item \code{show}: Display the information in the class. Currently empty.
\item \code{show_meta}: Display the metadata information stored in the \code{metadata}
field
}
}

\examples{

bc <- BiocCheck:::.BiocCheck

}
\seealso{
\link{Message-class}, \link{BiocPackage-class}
}
