% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getMCI}
\alias{getMCI}
\title{Calculating MCI Scores}
\usage{
getMCI(
  groups,
  countsL,
  adjust.size = FALSE,
  fun = c("cor", "BioTIP"),
  df = NULL
)
}
\arguments{
\item{groups}{A list of elements whose length is the member of states. The
elements could be either be vectors or \code{communities} object of the
R package \code{\link{igraph}}. If a vector, it is the output of the function
\code{getCluster_methods}. The names of each vector are the pre-selected
transcript IDs generated by the function \code{\link{sd_selection}}. Each
vector, whose length is the number of pre-selected transcripts in a state,
contains the module IDs. If a \code{communities} object, it can be obtained
by \code{getCluster_methods} using the "rw" method. It is also an output of
the function \code{\link{sd_selection}}.}

\item{countsL}{A list of x numeric count matrices or x data frame, where x is
the number of states.}

\item{adjust.size}{A Boolean value indicating if MCI score should be adjusted
by module size (the number of transcripts in the module) or not. Default FALSE.
This parameter is not recommended for fun=BioTIP.}

\item{fun}{A character chosen between ("cor", "BioTIP"), indicating where an adjusted
correlation matrix will be used to calculate the MCI score.}

\item{df}{NULL or a numeric matrix or data frame, where rows and columns represent
unique transcript IDs (geneID) and sample names, respectively.
Used only when \code{fun='BioTIP'}.
By default is NULL, estinating the correlation among selected genes.
Otherwise, estinating the correlation among all genes in the df, ensuring cross state comparision.}
}
\value{
A list of five elements (members,  MCI,  Sd,  PCC,  and PCCo). Each of
element is a two-layer nested list whose length is the length of the input
object \code{groups}. Each internal nested list is structured according to
the number of modules identified in that state.
\itemize{
\item members: vectors of unique ids
\item MCI: the MCI score
\item sd: standard deviation
\item PCC: Mean of pairwise Pearson Correlation Coefficient calculated among the
loci in a module.
\item PCCo: Mean of pairwise Pearson Correlation Coefficient calculated between
the loci in a module and the loci outside that module but inside the same
state.
}
}
\description{
This function calculates a module critical index (MCI) score for
each module per state within a dataset. Each module is a cluster of
transcripts generated from the function \code{\link{getCluster_methods}}.
Note that a dataset should contains three or more states (samples in
groups).
}
\examples{
test = list('state1' = matrix(sample(1:10, 6), 4, 3), 'state2' =
matrix(sample(1:10, 6), 4, 3), 'state3' = matrix(sample(1:10, 6), 4, 3))

## Assign colnames and rownames to the matrix
for(i in names(test)){
   colnames(test[[i]]) = 1:3
   row.names(test[[i]]) = c('g1', 'g2', 'g3', 'g4')}

cluster = list(c(1, 2, 2, 1), c(1, 2, 3, 1), c(2, 2, 1, 1))
names(cluster) = names(test)
for(i in names(cluster)){
   names(cluster[[i]]) = c('g1', 'g2', 'g3', 'g4')}

membersL_noweight <- getMCI(cluster, test, fun='cor')
names(membersL_noweight)
## [1] "members" "MCI"     "sd"      "PCC"     "PCCo"  

}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}; Xinan H Yang \email{xyang2@uchicago.edu}
}
