% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropyDiversity}
\alias{entropyDiversity}
\title{Entropy-based sample diversity}
\usage{
entropyDiversity(mat, norm = FALSE)
}
\arguments{
\item{mat}{A matrix (usually an expression matrix), with genes (features) in rows and samples in columns.}

\item{norm}{Logical, whether the diversity should be normalized by \code{log2(nrow(mat))}.}
}
\value{
A vector as long as the column number of the input matrix
}
\description{
Entropy-based sample diversity
}
\examples{
myMat <- rbind(c(3,4,5),c(6,6,6), c(0,2,4))
entropyDiversity(myMat)
entropyDiversity(myMat, norm=TRUE)

myRandomMat <- matrix(runif(1000), ncol=20)
entropyDiversity(myRandomMat)
entropyDiversity(myRandomMat, norm=TRUE)
}
\references{
Martinez and Reyes-Valdes (2008) Defining diversity, 
specialization, and gene specificity in transcriptomes through information 
theory. PNAS 105(28):9709--9714
}
\seealso{
\code{\link{entropy}} and \code{\link{sampleSpecialization}}
}
