% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropy.R
\name{entropy}
\alias{entropy}
\title{Shannon entropy}
\usage{
entropy(vector)
}
\arguments{
\item{vector}{A vector of numbers, or characters. Discrete probability of each item is calculated and the Shannon entropy is returned.}
}
\value{
Shannon entropy

Shannon entropy can be used as measures of gene expression
specificity, as well as measures of tissue diversity and
specialization. See references below.

We use \code{2} as base for the entropy calculation, because in this
base the unit of entropy is \emph{bit}.
}
\description{
Shannon entropy
}
\examples{
myVec0 <- 1:9
entropy(myVec0) ## log2(9)
myVec1 <- rep(1, 9)
entropy(myVec1)

entropy(LETTERS)
entropy(rep(LETTERS, 5))
}
\references{
Martinez and Reyes-Valdes (2008) Defining diversity, 
specialization, and gene specificity in transcriptomes through information 
theory. PNAS 105(28):9709--9714
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
