% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_stats.R
\name{net_stats}
\alias{net_stats}
\title{Calculate network statistics}
\usage{
net_stats(
  adj_matrix = NULL,
  net_type = c("gcn", "ppi", "grn"),
  calculate_additional = FALSE
)
}
\arguments{
\item{adj_matrix}{Adjacency matrix that represents the network.}

\item{net_type}{One of "gcn" (gene coexpression network),
"ppi" (protein-protein interaction), or "grn" (gene regulatory network).}

\item{calculate_additional}{Logical indicating whether to calculate
additional network statistics (betweenness and closeness).
Default is FALSE.}
}
\value{
A list containing the following elements: \itemize{
  \item Connectivity
  \item ScaledConnectivity
  \item ClusterCoef
  \item MAR (for gcn only)
  \item Density
  \item Centralization
  \item Heterogeneity (gcn only)
  \item Diameter
  \item Betweenness
  \item Closeness
}
}
\description{
Calculate network statistics
}
\examples{
\donttest{
data(filt.se)
set.seed(12)
filt.se <- exp_preprocess(
    filt.se, Zk_filtering = FALSE, variance_filter = TRUE, n = 200
)
gcn <- exp2gcn(
    filt.se, SFTpower = 7, cor_method = "pearson", net_type = "signed hybrid"
)
stats <- net_stats(gcn$adjacency_matrix, net_type = "gcn")
}
}
\seealso{
\code{\link[igraph]{graph_from_adjacency_matrix}},
 \code{\link[igraph]{cliques}},\code{\link[igraph]{diameter}},
 \code{\link[igraph]{estimate_betweenness}},\code{\link[igraph]{V}},
 \code{\link[igraph]{closeness}},\code{\link[igraph]{degree}},
 \code{\link[igraph]{transitivity}},\code{\link[igraph]{edge_density}},
 \code{\link[igraph]{centr_degree}}
 \code{\link[WGCNA]{fundamentalNetworkConcepts}}
}
