% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridgeness.R
\name{plotBridgeness}
\alias{plotBridgeness}
\title{Plot Bridgeness values}
\usage{
plotBridgeness(
  gg,
  alg,
  VIPs,
  Xatt = "SL",
  Xlab = "Semilocal Centrality (SL)",
  Ylab = "Bridgeness (B)",
  bsize = 3,
  spsize = 7,
  MainDivSize = 0.8,
  xmin = 0,
  xmax = 1,
  ymin = 0,
  ymax = 1,
  baseColor = "royalblue2",
  SPColor = "royalblue2"
)
}
\arguments{
\item{gg}{igraph object with bridgenes values stored as attributes,
after call to \code{\link{calcBridgeness}}}

\item{alg}{clustering algorithm that was used to calculate bridgeness values}

\item{VIPs}{list of 'specical' genes to be marked on the plot}

\item{Xatt}{name of the attribute that stores values to be used as X-axis
values. By default \code{SL} for semi-local centrality}

\item{Xlab}{label for the X-axis}

\item{Ylab}{label for the Y-axis}

\item{bsize}{point size for genes}

\item{spsize}{point size for 'specical' genes}

\item{MainDivSize}{size of the line for the region separation lines}

\item{xmin}{low limit for X-axis}

\item{xmax}{upper limit for X-axis}

\item{ymin}{low limit for Y-axis}

\item{ymax}{upper limit for Y-axis}

\item{baseColor}{basic color for genes}

\item{SPColor}{colour highlighting any 'specical' genes}
}
\value{
\code{\link[ggplot2]{ggplot}} object with plot
}
\description{
Semi-local centrality measure (Chen et al., 2011)
lies between 0 and 1 indicating whether protein is important globally or
locally. By plotting Bridgeness against semi-local centrality we can
categorises the influence each protein found in our network has on the
overall network structure:
\itemize{
\item Region 1, proteins having a 'global' rather than 'local' influence in
the network (also been called bottle-neck bridges, connector or kinless
hubs (0<Sl<0.5; 0.5<Br<1).
\item Region 2, proteins having 'global' and 'local' influence (0.5<Sl<1,
0.5<Br<1).
\item Region 3, proteins centred within the community they belong to, but also
communicating with a few other specific communities (0<Sl<0.5; 0.1<Br<0.5).
\item Region 4, proteins with 'local' impact , primarily within one or two
communities (local or party hubs, 0.5<Sl<1, 0<Br<0.5).
}
}
\examples{
karate <- make_graph("Zachary")
# We need vertex ID in the 'name' attribute of the vertex
V(karate)$name<-c(LETTERS,letters)[1:vcount(karate)]
set.seed(100)
gg <- calcClustering(karate, 'louvain')
gg <- calcCentrality(gg)
cnmat <- makeConsensusMatrix(gg, N=10, alg = 'louvain', type = 2, mask = 10)
gg<-calcBridgeness(gg, alg = 'louvain', cnmat)
plotBridgeness(gg,alg = 'louvain',VIPs=c("Mr Hi","John A"))
}
