% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mutation_cpp}
\alias{mutation_cpp}
\title{Function to mutate the offspring}
\usage{
mutation_cpp(offspring, mutation_rate)
}
\arguments{
\item{offspring}{Numeric matrix representing the offspring.}

\item{mutation_rate}{Probability of mutation for each individual.}
}
\value{
Numeric matrix representing the mutated offspring.
}
\description{
Function to mutate the offspring
}
\examples{
# example of usage
genomic_data <- matrix(rnorm(100), nrow = 10, ncol = 10)
population <- BioGA::initialize_population_cpp(genomic_data,
                population_size = 5)
fitness <- BioGA::evaluate_fitness_cpp(genomic_data, population)
selected_parents <- BioGA::selection_cpp(population,
                fitness, num_parents = 2)
offspring <- BioGA::crossover_cpp(selected_parents, offspring_size = 2)
BioGA::mutation_cpp(offspring, mutation_rate = 0)
}
