% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocarta.R
\name{pos_by_polygon}
\alias{pos_by_polygon}
\title{Position around a polygon}
\usage{
pos_by_polygon(
  x,
  y,
  where = c("left", "right", "top", "bottom", "topleft", "topright", "bottomleft",
    "bottomright")
)
}
\arguments{
\item{x}{x-coordinate of a polygon.}

\item{y}{y-coordinate of a polygon.}

\item{where}{Which side of the polygon? It should take value in \code{c("left", "right", "top", "bottom", "topleft", "topright", "bottomleft", "bottomright")}.}
}
\value{
A numeric scalar of length two, which is the xy-coordinate of the point.
}
\description{
Position around a polygon
}
\examples{
x = c(235, 235, 237, 241, 246, 248, 250, 250, 250, 253,
      256, 260, 264, 263, 261, 257, 252, 247, 241, 237, 235)
y = c(418, 409, 402, 397, 394, 395, 396, 404, 411, 416, 417, 
      416, 415, 422, 429, 434, 437, 436, 432, 426, 418)
pos_by_polygon(x, y, "left")
pos_by_polygon(x, y, "bottomleft")
}
