% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{supportRatio}
\alias{supportRatio}
\title{Support ratio function for BSFDataSet objects}
\usage{
supportRatio(object, bsWidths, bsFlank = NA, sub.chr = NA, ...)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{bsWidths}{a numeric vector indicating the different binding site
width to compute the ratio for}

\item{bsFlank}{optional; a numeric vector of the same length as
\code{bsWidth} used to specify the width of the flanking regions}

\item{sub.chr}{chromosome identifier (eg, chr1, chr2) used for subsetting the
BSFDataSet object.}

\item{...}{further arguments passed to \code{makeBindingSites}}
}
\value{
an object of class \code{data.frame}
}
\description{
Functions that computes a ratio to determine how well a given binding site
with is supported by the crosslink coverage of the data. For a given
\code{BSFDataSet} object binding sites are computed for each width indicated
in the \code{bsWidths} vector (using the \code{\link{coverageOverRanges}}
function). These coverages are compared to the coverage of regions flanking
the binding sites. If not indicated in \code{bsFlank} these regions are of
the same width as the binding sites.
}
\details{
Testing the width of 3nt for example, would result in a coverage within all
3nt wide binding sites (c1) and a coverage computed on the adjacent 3nt
flanking the binding sites up- and downstream (f1, f2). Based on these
 numbers the ratio is computed by: c1/(1/2(f1+f2)).

The median over all ratios is reported as representative value.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

suppressWarnings(supportRatio(bds, bsWidths = c(3,7)))

}
