% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{getSignal}
\alias{getSignal}
\alias{getSignal,BSFDataSet-method}
\title{Accessor method for the signal data of the BSFDataSet object}
\usage{
getSignal(object)

\S4method{getSignal}{BSFDataSet}(object)
}
\arguments{
\item{object}{a BSFDataSet object}
}
\value{
returns the signal data, as list of RLE list for each strand, named
after the meta data columns "clPlus" and "clMinus"
}
\description{
Signal data is loaded from the path specified in \code{\link{getMeta}}
columns "clPlus" and "clMinus" and stored as a list of RLE lists.
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

getSignal(bds)

}
\seealso{
\code{\link{getMeta}} \code{\link{BSFDataSet}}
}
