% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialPlots.R
\name{geneRegulationPlot}
\alias{geneRegulationPlot}
\title{Gene Regulation Plot}
\usage{
geneRegulationPlot(
  object,
  plot.geneID = NULL,
  anno.annoDB = NULL,
  anno.genes = NULL,
  match.geneID = "gene_id",
  match.geneName = "gene_name",
  plot.gene.n.tiles = 100,
  alpha = 0.05,
  lfc.cutoff = 2,
  transcript.regions.outlier.handle = c("first", "second", "both", "remove"),
  quiet = FALSE
)
}
\arguments{
\item{object}{object; a \code{\link{BSFDataSet}} object}

\item{plot.geneID}{character;  the gene id of the gene to display. The id must
match with the gene ids given in the annotation object.}

\item{anno.annoDB}{object; an object of class \code{OrganismDbi} that contains
the gene annotation (!!! Experimental !!!).}

\item{anno.genes}{object; an object of class \code{\link{GenomicRanges}}
that represents the gene ranges directly.}

\item{match.geneID}{character; meta column name of the gene ID}

\item{match.geneName}{character; meta column name of the gene name}

\item{plot.gene.n.tiles}{numeric; number of tiles the gene should be split in}

\item{alpha}{numeric; the alpha value to show significantly regulated
binding sites. This should match the alpha value used in \code{\link{calculateBsFoldChange}}.}

\item{lfc.cutoff}{numeric; log2 fold-change cutoff to show significantly
regulated binding sites. This should match the lfc.cutoff value used in
\code{\link{calculateBsFoldChange}}.}

\item{transcript.regions.outlier.handle}{character; the option how to handle
multiple transcript region annotations being present for the same binding
site.}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of class \code{ggplot2}
}
\description{
Display the fold-change of all binding sites from a given gene on a relative
per-nucleotide scale. Binding sites are displayed as dots and with increasing
log2 fold-change, they deviate stronger from the center line.
}
\details{
For this function to work, binding sites must be assigned to hosting genes
using \code{\link{assignToGenes}}. It is also recommended to assing
binding sites to transcript regions with \code{\link{assignToTranscriptRegions}}.

It is also necessary to calculate the log2 fold-change of binding sites between
two conditions using the differential binding workflow \code{\link{calculateBsFoldChange}}.

If in addition the transcript regions of the binding sites are given, then
shapes are changed accordingly. An edge case can arise from the merging of two
\code{\link{BSFDataSet}} objects. If binding sites are overlapping and
slightly offset close to the end of a particular transcript region annotation,
they might be assigned to different regions in both objects. This results in
some ambiguity after the merge, where for instance a binding site can be
assigned to CDS and 3'UTR. To handle how such edge cases are displayed, the
\code{transcript.regions.outlier.handle} exists. As default, simply the
region of the object that was merged first is shown. If one is interested in
showing all regions, then the options \code{both} displays both annotations
at the same time and labels them accordingly.
}
\examples{

# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
load(list.files(files, pattern = ".rds$", full.names = TRUE)[2])

# make testset
bds = makeBindingSites(bds, bsSize = 7)
bds = assignToGenes(bds, anno.genes = gns)
bds = assignToTranscriptRegions(object = bds, anno.transcriptRegionList = regions)
bds = imputeBsDifferencesForTestdata(bds)
bds = calculateBsBackground(bds, anno.genes = gns, use.offset = FALSE)

# use all filters and remove binding sites that fail (default settings)
bds = filterBsBackground(bds)

# calculate fold-changes
bds = calculateBsFoldChange(bds)

# make example plot
exampleGeneId = "ENSG00000253352.10"
geneRegulationPlot(bds, plot.geneID = exampleGeneId, anno.genes = gns)

}
\seealso{
\code{\link{BSFind}},
\code{\link{calculateBsFoldChange}}
\code{\link{assignToGenes}}
\code{\link{assignToTranscriptRegions}}
}
