% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{assignToTranscriptRegions}
\alias{assignToTranscriptRegions}
\title{Assign binding sites to their hosting transcript regions}
\usage{
assignToTranscriptRegions(
  object,
  overlaps = c("frequency", "hierarchy", "flag", "remove"),
  overlaps.rule = NULL,
  anno.annoDB = NULL,
  anno.transcriptRegionList = NULL,
  normalize.exclude.upper = 0.02,
  normalize.exclude.lower = 0.02,
  quiet = FALSE
)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object with stored binding sites. This
means that ranges should be > 1}

\item{overlaps}{character; how overlapping transcript regions should be handled.}

\item{overlaps.rule}{character vector; a vector of transcript region
names that should be used to handle overlapping cases in a hierarchical manor.
The order of the vector is the order of the hierarchy.}

\item{anno.annoDB}{an object of class \code{OrganismDbi} that contains
the transcript region annotation (!!! Experimental !!!).}

\item{anno.transcriptRegionList}{an object of class \code{\link{CompressedGRangesList}}
that holds an ranges for each transcript region}

\item{normalize.exclude.upper}{numeric; percentage value that indicates the
upper boundary for transcript region length to be considered when calculating
normalization factors for regions.}

\item{normalize.exclude.lower}{numeric; percentage value that indicates the
lower boundary for transcript region length to be considered when calculating
normalization factors for regions.}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of class \code{\link{BSFDataSet}} with binding sites having
hosting transcript region information added to their meta columns.
}
\description{
Function that assigns each binding site in the \code{\link{BSFDataSet}} to its
hosting transcript region given an annotation database (\code{anno.annoDB}), or
a GRanges list / \code{\link{CompressedGRangesList}} (\code{anno.transcriptRegionList})
that holds the ranges for the transcript regions of interest.
}
\details{
Since the assignment is based on the overlaps of annotated transcript ranges
and binding sites, no matching meta data is needed.

In the case of transcript regions overlaps are very frequent. To resolve these
cases the \code{\link{overlaps}} argument can be used. Option `frequency`
will take the most frequently observed transcript region, option `hierarchy`
works in conjunction with a user defined rule (\code{overlaps.rule}).
Options `flag` and `remove` will label binding sites with an ambiguous tag or
remove all overlapping cases, respectively.

The function is part of the standard workflow performed by \code{\link{BSFind}}.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
load(list.files(files, pattern = ".rds$", full.names = TRUE)[2])

bds = makeBindingSites(object = bds, bsSize = 9)
bds = assignToGenes(bds, anno.genes = gns)
bds = assignToTranscriptRegions(object = bds, anno.transcriptRegionList = regions)

}
\seealso{
\code{\link{BSFind}},
\code{\link{transcriptRegionOverlapsPlot}},
\code{\link{transcriptRegionSpectrumPlot}}
}
