% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{download_fasta_intergenic}
\alias{download_fasta_intergenic}
\title{Download fasta intergenic}
\usage{
download_fasta_intergenic(
  myBgeeMetadata = new("BgeeMetadata"),
  myUserMetadata,
  intergenic_file
)
}
\arguments{
\item{myBgeeMetadata}{A Reference Class BgeeMetadata object (optional)}

\item{myUserMetadata}{A Reference Class UserMetadata object.}

\item{intergenic_file}{path where intergenic file will be saved}
}
\value{
download fasta intergenic from Bgee FTP or from the Zenodo community and save it
locally
}
\description{
Check if reference intergenic fasta file has already
been downloaded. If not the file is downloaded from Bgee FTP or from
the community repository depending on myBgeeMetadata@intergenic_release.
if myBgeeMetadata@intergenic_release == "community" then reference intergenic
wil be downloaded from the Zenodo community repository. Otherwise Reference
intergenic sequences will be downloaded from the official Bgee FTP.
Be careful when using reference intergenic sequences generated by the community
as the Bgee team do not deeply review them.
}
\examples{
{
bgee_intergenic_file <- file.path(getwd(), 'intergenic.fasta')
userMetadata <- new('UserMetadata', species_id = '7227')
}

}
