% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kallisto.R
\name{create_kallisto_index}
\alias{create_kallisto_index}
\title{Create kallisto indexes.}
\usage{
create_kallisto_index(
  myKallistoMetadata,
  myBgeeMetadata,
  myUserMetadata,
  transcriptome_path = ""
)
}
\arguments{
\item{myKallistoMetadata}{A Reference Class KallistoMetadata object.}

\item{myBgeeMetadata}{A Reference Class BgeeMetadata object.}

\item{myUserMetadata}{A Reference Class UserMetadata object.}

\item{transcriptome_path}{path to the transcriptome fasta file. 
If no path is provided the default path created using BgeeCall
will be used. IMPORTANT : in BgeeCall the transcriptome used
to generate present/absent calls contains both intergenic sequences 
downloaded from Bgee and the reference transcriptome. If this 
function is run to generate present/absent then 'transcriptome_path' 
has to be empty}
}
\value{
create kallisto index and save it on the hard drive
}
\description{
This function creates kallisto indexes. 
Two indexes can be created depending on the reads size (see 
`myKallistoMetadata@read_size_kmer_threshold` and `UserMetadata@reads_size` 
for more information). One with default kmer value (31 nt) and one with 
kmer size of 15 nt. In order to generate.
}
\examples{
\dontrun{
# first a transcriptome is needed. Here it is downloaded from AnnotationHub
library(AnnotationHub)
ah <- AnnotationHub()
ah_resources <- query(ah, c('Ensembl', 'Caenorhabditis elegans', '84'))

# kallisto can not deal with S4 objects. A Path to a transcriptome file is 
# required
transcriptome_object <- rtracklayer::import.2bit(ah_resources[['AH50453']])
transcriptome_path <- file.path(getwd(),'transcriptome.fa')
Biostrings::writeXStringSet(transcriptome_object, transcriptome_path)



# initialize objects needed to create destination folder
bgee <- new('BgeeMetadata')
user <- new('UserMetadata', species_id = '6239')
kallisto <- new('KallistoMetadata')

# generate transcriptome index
create_kallisto_index(kallisto, bgee, user, transcriptome_path)
}

}
\author{
Julien Wollbrett.
}
