% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcChain.R
\name{mcmcChain}
\alias{mcmcChain}
\alias{removeChain}
\title{Read MCMC chain associated with a BayesSpace clustering or enhancement}
\usage{
mcmcChain(sce, params = NULL)

removeChain(sce)
}
\arguments{
\item{sce}{SingleCellExperiment with a file path stored in its metadata.}

\item{params}{List of model parameters to read}
}
\value{
Returns an \code{mcmc} object containing the values of the requested
parameters over the constructed chain.
}
\description{
BayesSpace stores the MCMC chain associated with a clustering or enhancement
on disk in an HDF5 file. The \code{mcmcChain()} function reads any parameters
specified by the user into a \code{coda::mcmc} object compatible with
TidyBayes.
}
\details{
To interact with the HDF5 file directly, obtain the filename from the
SingleCellExperiment's metadata: \code{metadata(sce)$chain.h5}. Each
parameter is stored as a separate dataset in the file, and is represented as
a matrix of size (n_iterations x n_parameter_indices). Parameter choices
for the spot-level clustering include:
\itemize{
\item \code{z} (cluster assignments)
\item \code{weights} (\eqn{w_i})
\item \code{mu} (mean vectors)
\item \code{lambda} (precision matrix)
\item \code{plogLik} (pseudo-log-likelihood)
}

Parameter choices for the subspot-level enhanced clustering include:
\itemize{
\item \code{z} (cluster assignments)
\item \code{weights} (\eqn{w_i})
\item \code{Y} (enhanced PCs)
\item \code{mu} (mean vectors)
\item \code{lambda} (precision matrix)
\item \code{Ychange} (acceptance rate for the jittering of PCs)
}

For best results, \code{Ychange} should average between 0.25 and 0.40.
}
\examples{
set.seed(149)
sce <- exampleSCE()
sce <- spatialCluster(sce, 7, nrep=100, burn.in=10, save.chain=TRUE)
chain <- mcmcChain(sce)
removeChain(sce)

}
