% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialCluster.R
\name{spatialCluster}
\alias{spatialCluster}
\title{Spatial clustering}
\usage{
spatialCluster(
  sce,
  q,
  use.dimred = "PCA",
  d = 15,
  platform = c("Visium", "VisiumHD", "ST"),
  init = NULL,
  init.method = c("mclust", "kmeans"),
  model = c("t", "normal"),
  precision = c("equal", "variable"),
  nrep = 50000,
  burn.in = 1000,
  thin = 100,
  gamma = NULL,
  mu0 = NULL,
  lambda0 = NULL,
  alpha = 1,
  beta = 0.01,
  save.chain = FALSE,
  chain.fname = NULL
)
}
\arguments{
\item{sce}{A SingleCellExperiment object containing the spatial data.}

\item{q}{The number of clusters.}

\item{use.dimred}{Name of a reduced dimensionality result in
\code{reducedDims(sce)}. If provided, cluster on these features directly.}

\item{d}{Number of top principal components to use when clustering.}

\item{platform}{Spatial transcriptomic platform. Specify 'Visium' for hex
lattice geometry or 'ST' and 'VisiumHD' for square lattice geometry.
Specifying this parameter is optional when analyzing SingleCellExperiments
processed using \code{\link{readVisium}}, \code{\link{spatialPreprocess}},
or \code{\link{spatialCluster}}, as this information is included in their
metadata.}

\item{init}{Initial cluster assignments for spots.}

\item{init.method}{If \code{init} is not provided, cluster the top \code{d}
PCs with this method to obtain initial cluster assignments.}

\item{model}{Error model. ('normal' or 't')}

\item{precision}{Covariance structure. ('equal' or 'variable' for EEE and
VVV covariance models, respectively.)}

\item{nrep}{The number of MCMC iterations.}

\item{burn.in}{The number of MCMC iterations to exclude as burn-in period.}

\item{thin}{Thinning rate.}

\item{gamma}{Smoothing parameter. Defaults to 2 for \code{platform="ST"} and
3 for \code{platform="Visium"}. (Values in range of 1-3 seem to work well.)}

\item{mu0}{Prior mean hyperparameter for mu. If not provided, mu0 is set to
the mean of PCs over all spots.}

\item{lambda0}{Prior precision hyperparam for mu. If not provided, lambda0
is set to a diagonal matrix \eqn{0.01 I}.}

\item{alpha}{Hyperparameter for Wishart distributed precision lambda.}

\item{beta}{Hyperparameter for Wishart distributed precision lambda.}

\item{save.chain}{If true, save the MCMC chain to an HDF5 file.}

\item{chain.fname}{File path for saved chain. Tempfile used if not provided.}
}
\value{
Returns a modified \code{sce} with cluster assignments stored in
  \code{colData} under the name \code{spatial.cluster}.
}
\description{
Cluster a spatial expression dataset.
}
\details{
The input SCE must have \code{row} and \code{col} columns in its
\code{colData}, corresponding to the array row and column coordinates of each
spot. These are automatically parsed by \code{\link{readVisium}} or can be
added manually when creating the SCE.

Cluster labels are stored in the \code{spatial.cluster} column of the SCE,
and the cluster initialization is stored in \code{cluster.init}.
}
\examples{
set.seed(149)
sce <- exampleSCE()
sce <- spatialCluster(sce, 7, nrep = 100, burn.in = 10)

}
\seealso{
\code{\link{spatialPreprocess}} for preparing the SCE for
  clustering, \code{\link{spatialEnhance}} for enhancing the clustering
  resolution, \code{\link{clusterPlot}} for visualizing the cluster
  assignments, \code{\link{featurePlot}} for visualizing expression levels
  in spatial context, and \code{\link{mcmcChain}} for examining the full
  MCMC chain associated with the clustering.
}
