% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kBET.R
\name{bisect}
\alias{bisect}
\title{bisect - a generic bisection function}
\usage{
bisect(foo, bounds, known = NULL, ..., tolx = 5, toly = 0.01)
}
\arguments{
\item{foo}{a function mapping a one-dim argument to one-dim value}

\item{bounds}{a vector of length 2 with real valued numbers
(i.e. two arguments of \code{foo})}

\item{known}{tells for which of the arguments a value is known
(defaults to NULL)}

\item{...}{additional parameters for \code{foo}}

\item{tolx}{break condition for argument (defaults to 10)}

\item{toly}{break condition for value (defaults to 0.01)}
}
\value{
A range of bounds where \code{foo} is maximal.
}
\description{
adapted from kBET package (https://github.com/theislab/kBET).
Provides recursive bisection algorithm for an arbitrary function. It
evaluates the function \code{foo} at the bounds and replaces one of the
boundaries until a maximum is found or the interval becomes too small
}
\examples{
get_maximum <- bisect(function(x) {
  -(x - 2)^2
}, c(-5, 50))

}
