% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{normalize_SE}
\alias{normalize_SE}
\title{This function allows you to add normalized count matrix to the SE object}
\usage{
normalize_SE(
  se,
  method,
  log_bool,
  assay_to_normalize,
  output_assay_name,
  condition = NULL,
  batch = NULL
)
}
\arguments{
\item{se}{SummarizedExperiment Object}

\item{method}{string; Normalization Method, either 'CPM', 'DESeq', 'edgeR',
'voom', or 'none' for log(x+1) only}

\item{log_bool}{True or False; True to log normalize the data set after
normalization method}

\item{assay_to_normalize}{string; SE assay to do normalization on}

\item{output_assay_name}{string; name for the resulting normalized assay}

\item{condition}{string; the biological variable of interest, required for
voom, default 'NULL'}

\item{batch}{string; the batch variable, required for voom, default 'NULL'}
}
\value{
the original SE object with normalized assay appended
}
\description{
This function allows you to add normalized count matrix to the SE object
}
\examples{
library(scran)
se <- mockSCE()
se_CPM_normalized <- BatchQC::normalize_SE(se, method = "CPM",
                                log_bool = FALSE,
                                assay_to_normalize = "counts",
                                output_assay_name =
                                    "CPM_normalized_counts")
se_DESeq_normalized <- BatchQC::normalize_SE(se, method = "DESeq",
                                log_bool = FALSE,
                                assay_to_normalize = "counts",
                                output_assay_name =
                                    "DESeq_normalized_counts")
se_CPM_normalized
se_DESeq_normalized

}
