% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity.R
\name{match_style}
\alias{match_style}
\title{Match chromosome naming styles of annotation and genome}
\usage{
match_style(Genome, annot, style)
}
\arguments{
\item{Genome}{Either a \code{\link{BSgenome}} or a \code{\link{XStringSet}}
object of genomic sequences, where the intronic sequences will be extracted
from. Use \code{\link{genomeStyles}} to check which styles are supported for
your organism of interest; supported styles can be interconverted. If the
style in your genome or annotation is not supported, then the style of
chromosome names in the genome and annotation should be manually set to be
consistent.}

\item{annot}{Genome annotation, an object of a class with a
\code{\link{seqlevels}} method, such as \code{GRanges}, \code{TxDb}, and \code{EnsDb}.}

\item{style}{Formatting of chromosome names. Use
\code{\link{genomeStyles}} to check which styles are supported for your
organism of interest and what those styles look like. This can also be a
style supported for your organism different from the style used by the
annotation and the genome. Then this style will be used for both the
annotation and the genome. Can take the following values:
\describe{
\item{genome}{If style of the annnotation is different from that of the
genome, then the style of the genome will be used.}
\item{other}{Custom style, need to manually ensure that the style in
annotation matches that of the genome.}
\item{Ensembl}{Or \code{UCSC} or \code{NCBI}, whichever is supported by your species
of interest.}
}}
}
\value{
A list of two. The first element is the genome with the proper style,
and the second element is the annotation with the proper style.
}
\description{
Internal use. This function matches chromosome naming styles. It will also
give the genome and the annotation the same \code{genome} slot. This function
assumes that the annotation and the genome refer to the same version of
genome. If more than one style, then the first element will be used.
}
