% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tx.R
\name{dl_transcriptome}
\alias{dl_transcriptome}
\title{Download transcriptome from Ensembl}
\usage{
dl_transcriptome(
  species,
  out_path = ".",
  type = c("vertebrate", "metazoa", "plant", "fungus", "protist"),
  transcript_biotype_use = "all",
  gene_biotype_use = "all",
  chrs_only = TRUE,
  ensembl_version = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{species}{Character vector of length 1, Latin name of the species of
interest.}

\item{out_path}{Directory to save the outputs written to disk. If this
directory does not exist, then it will be created. Defaults to the current
working directory.}

\item{type}{Character, must be one of "vertebrate", "metazoa", "plant",
"fungus" and "protist". Passing "vertebrate" will use the default
www.ensembl.org host. Gene annotation of some common invertebrate model
organisms, such as \emph{Drosophila melanogaster}, are available on www.ensembl.org
so for these invertebrate model organisms, "vertebrate" can be used for this
argument. Passing values other than "vertebrate" will use other Ensembl hosts.
For animals absent from www.ensembl.org, try "metazoa".}

\item{transcript_biotype_use}{Character, can be "all" or
a vector of \emph{transcript} biotypes to be used. Transcript biotypes aren't
entirely the same as gene biotypes. For instance, in Ensembl annotation,
\code{retained_intron} is a transcript biotype, but not a gene biotype. If
"cellranger", then a warning will be given. See \code{data("ensembl_tx_biotypes")}
for all available transcript biotypes from Ensembl.}

\item{gene_biotype_use}{Character, can be "all", "cellranger", or
a vector of \emph{gene} biotypes to be used. If "cellranger", then the biotypes
used by Cell Ranger's reference are used. See \code{data("cellranger_biotypes")}
for gene biotypes the Cell Ranger reference uses. See
\code{data("ensembl_gene_biotypes")} for all available gene biotypes from Ensembl.
Note that gene biotypes and transcript biotypes are not always the same.}

\item{chrs_only}{Logical, whether to include chromosomes only, for GTF and
GFF files can contain annotations for scaffolds, which are not incorporated
into chromosomes. This will also exclude haplotypes. Defaults to \code{TRUE}.
Only applicable to species found in \code{genomeStyles()}.}

\item{ensembl_version}{Integer version number of Ensembl (e.g. 94 for the
October 2018 release). This argument defaults to \code{NULL}, which will use
the current release of Ensembl. Use
\code{\link{listEnsemblArchives}} to see the version number corresponding
to the Ensembl release of a particular date. The version specified here must
match the version of Ensembl where the transcriptome used to build the
kallisto index was downloaded. This only works for vertebrates and the most
common invertebrate model organisms like \emph{Drosophila melanogaster} and
\emph{C. elegans} (i.e. www.ensembl.org and its mirrors), not the other Ensembl
sites for plants, protists, fungi, and metazoa.}

\item{verbose}{Whether to display progress.}

\item{...}{Other arguments passed to \code{tr2g_fasta}.}
}
\value{
Invisibly returns the path to the fasta file. The following files are
written to disk, in the \code{out_path} directory:
\describe{
\item{species.genome.cdna.all.fa.gz}{The cDNA fasta file from Ensembl, from
the specified version.}
\item{cdna_filtered.fa}{The filtered cDNA fasta file, only keeping the
desired biotypes and without scaffolds and haplotypes (if
\code{chrs_only = TRUE}). This file will not be written if all gene and transcript
biotypes are used and scaffolds and haplotypes are not removed.}
\item{tr2g.tsv}{The transcript to gene file, without headers so can be
directly used for \code{bustools}.}
}
}
\description{
This function downloads the cDNA fasta file from specific version of Ensembl.
It can also filter the fasta file by gene and transcript biotype and remove
scaffolds and haplotypes.
}
\examples{
dl_transcriptome("Drosophila melanogaster", gene_biotype_use = "cellranger",
                 chrs_only = FALSE)
# Clean up
file.remove("Drosophila_melanogaster.BDGP6.32.cdna.all.fa.gz")
}
