% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tr2g.R
\name{EC2gene}
\alias{EC2gene}
\title{Map EC Index to Genes Compatible with the EC}
\usage{
EC2gene(tr2g, kallisto_out_path, verbose = TRUE)
}
\arguments{
\item{tr2g}{A Data frame with columns \code{gene} and \code{transcript}, in
the same order as in the transcriptome index for \code{kallisto}.}

\item{kallisto_out_path}{Path to the \code{kallisto bus} output directory.}

\item{verbose}{Logical, whether to display progress.}
}
\value{
A data frame with 3 columns:
\describe{
\item{EC_ind}{Index of the EC as appearing in the \code{matrix.ec} file.}
\item{EC}{A list column each element of which is a numeric vector of the
transcripts in the EC corresponding to the EC index. To learn more about list
columns, see the \href{https://r4ds.had.co.nz/many-models.html#list-columns-1}{relevant section in the R for Data Science book}.}
\item{gene}{A list column each element of which is a character vector of genes
the EC maps to.}
}
}
\description{
In the output file \code{output.bus}, equivalence classes (EC) are denoted by
an index, which is related to the set of transcripts the EC is compatible to
in the output file \code{matrix.ec}. This function further relates the set of
transcripts to the set of genes the EC is compatible to. This function first
reads in \code{matrix.ec}, and then translates the transcripts into genes.
}
\details{
The data frame passed to \code{tr2g} can be generated from function
\code{\link{transcript2gene}} in this package for any organism that has gene and
transcript ID on Ensembl, or from the \code{tr2g_*} family of function.
You no longer need to use this function before running \code{make_sparse_matrix};
the purpose of this function is to query which genes equivalence classes map
to.

Calling this function is unnessary when working with gene count matrices.
However, this function is useful for finding genes the ECs map to in TCC
matrices, such as when finding species-specific ECs in mixed species datasets
and identifying ECs mapped to known marker genes of cell types.
}
\examples{
# Load toy example for testing
toy_path <- system.file("testdata", package = "BUSpaRse")
load(paste(toy_path, "toy_example.RData", sep = "/"))
EC2gene(tr2g_toy, toy_path, verbose = FALSE)
}
\seealso{
\code{\link{transcript2gene}}
}
