% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneAnalysis.R
\name{bilevelAnalysisClassic}
\alias{bilevelAnalysisClassic}
\title{Bi-level meta-analysis in conjunction with a classical 
hypothesis testing method}
\usage{
bilevelAnalysisClassic(x, y = NULL, splitSize = 5, metaMethod = addCLT,
  func = t.test, p.value = "p.value", ...)
}
\arguments{
\item{x}{a list of numeric vectors}

\item{y}{an optional list of numeric vectors}

\item{splitSize}{the minimum number of size in each split sample. 
splitSize should be at least 3. By default, splitSize=5}

\item{metaMethod}{the method used to combine p-values. This should be one 
of addCLT (additive method [1]), fishersMethod (Fisher's method [5]), 
stoufferMethod (Stouffer's method [6]), max (maxP method [7]), 
or min (minP method [8])}

\item{func}{the name of the hypothesis test. By default func=t.test}

\item{p.value}{the component that returns the p-value after performing the 
test provided by the \emph{func} parameter. For example, the function 
t-test returns the class "htest" where the component "p.value" is the 
p-value of the test. By default, p.value="p.value"}

\item{...}{additional parameters for \emph{func}}
}
\value{
the combined p-value
}
\description{
Perform a bi-level meta-analysis in conjunction with any of 
the classical hypothesis testing methods, such as t-test, Wilcoxon test, etc.
}
\details{
This function performs a bi-level meta-analysis for the lists 
of samples [1]. It performs intra-experiment analyses to compare the 
vectors in x agains the corresponding vectors in y using the function 
\code{\link{intraAnalysisClassic}} in conjunction with the test provided 
in \emph{func}. For example, it compares the first vector in x with the 
first vector in y, the second vector in x with the second vector in y, etc. 
When y is null, then the comparisons are reduced to one-sample tests. After 
these comparisons, we have a list of p-values, one for each comparision. 
The function then combines these p-values to obtain a single p-value 
using \emph{metaMethod}.
}
\examples{
set.seed(1)
l1 <- lapply(as.list(seq(3)),FUN=function (x) rnorm(n=10, mean=1))
l1
# one-sample t-test
lapply(l1, FUN=function(x) t.test(x, alternative="greater")$p.value)
# combining the p-values of one-sample t-tests:
addCLT(unlist(lapply(l1, FUN=function(x) t.test(x, alter="g")$p.value)))
#Bi-level meta-analysis
bilevelAnalysisClassic(x=l1, alternative="greater")
}
\author{
Tin Nguyen and Sorin Draghici
}
\references{
[1] T. Nguyen, R. Tagett, M. Donato, C. Mitrea, and S. Draghici. A novel 
bi-level meta-analysis approach -- applied to biological pathway analysis. 
Bioinformatics, 32(3):409-416, 2016.
}
\seealso{
\code{\link{intraAnalysisClassic}}, \code{\link{intraAnalysisGene}}, \code{\link{bilevelAnalysisGene}}
}

