% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_asw.R
\name{compute_asw}
\alias{compute_asw}
\title{Compute the average silhouette width (ASW) for the dataset with respect
to both label and batch.}
\usage{
compute_asw(dataset)
}
\arguments{
\item{dataset}{Dataframe in the shape (samples, features) with additional
columns Batch and Label.}
}
\value{
List with fields "Label" and "Batch" for the ASW with regards to
Label and Batch respectively.
}
\description{
Columns labelled Batch, Sample, Label, Reference and Cov_1 will be ignored.
}
\examples{
# generate dataset with 1000 features, 5 batches, 10 samples per batch and
# two genotypes
data = generate_dataset(1000,5,10,0.1, 2)
asw = compute_asw(data)
asw
}
