% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_TestDE.R
\name{BASiCS_TestDE}
\alias{BASiCS_TestDE}
\title{Detection of genes with changes in expression}
\usage{
BASiCS_TestDE(
  Chain1,
  Chain2,
  EpsilonM = log2(1.5),
  EpsilonD = log2(1.5),
  EpsilonR = log2(1.5)/log2(exp(1)),
  ProbThresholdM = 2/3,
  ProbThresholdD = 2/3,
  ProbThresholdR = 2/3,
  OrderVariable = c("GeneIndex", "GeneName", "Mu"),
  GroupLabel1 = "Group1",
  GroupLabel2 = "Group2",
  Plot = TRUE,
  PlotOffset = TRUE,
  PlotOffsetType = c("offset estimate", "before-after", "MA plot"),
  Offset = TRUE,
  EFDR_M = 0.05,
  EFDR_D = 0.05,
  EFDR_R = 0.05,
  GenesSelect = rep(TRUE, ncol(Chain1@parameters[["mu"]])),
  min.mean = 1,
  MinESS = 100,
  ...
)
}
\arguments{
\item{Chain1}{an object of class \code{\linkS4class{BASiCS_Chain}}
containing parameter estimates for the first group of cells}

\item{Chain2}{an object of class \code{\linkS4class{BASiCS_Chain}}
containing parameter estimates for the second group of cells}

\item{EpsilonM}{Minimum fold change tolerance threshold for detecting
changes in overall expression (must be a positive real number).
Default value: \code{EpsilonM = log2(1.5)} (i.e. 50\% increase).}

\item{EpsilonD}{Minimum fold change tolerance threshold for detecting
changes in biological over-dispersion (must be a positive real number).
Default value: \code{EpsilonM = log2(1.5)} (i.e. 50\% increase).}

\item{EpsilonR}{Minimum distance threshold for detecting
changes in residual over-dispersion (must be a positive real number).
Default value: \code{EpsilonR= log2(1.5)/log2(exp(1))} (i.e. 50\% increase).}

\item{ProbThresholdM}{Optional parameter. Probability threshold for detecting
changes in overall expression (must be a positive value, between 0 and 1).
If \code{EFDR_M = NULL}, the posterior probability threshold for the
differential mean expression test will be set to \code{ProbThresholdM}. If
a value for \code{EFDR_M} is provided, the posterior probability threshold
is chosen to achieve an EFDR equal to \code{EFDR_M} and \code{ProbThresholdM}
defines a minimum probability threshold for this calibration (this avoids low
values of \code{ProbThresholdM} to be chosen by the EFDR calibration.
Default value \code{ProbThresholdM = 2/3}, i.e. the probability of observing
a log2-FC above \code{EpsilonM} must be at least twice the probality of
observing the complementary event (log2-FC below \code{EpsilonM}).}

\item{ProbThresholdD}{Optional parameter. Probability threshold for detecting
changes in cell-to-cell biological over-dispersion (must be a positive value,
between 0 and 1). Same usage as \code{ProbThresholdM}, depending on the value
provided for \code{EFDR_D}. Default value \code{ProbThresholdD = 2/3}.}

\item{ProbThresholdR}{Optional parameter. Probability threshold for detecting
changes in residual over-dispersion (must be a positive value, between 0 and
1). Same usage as \code{ProbThresholdM}, depending on the value provided for
\code{EFDR_R}. Default value \code{ProbThresholdR = 2/3}.}

\item{OrderVariable}{Ordering variable for output.
Possible values: \code{'GeneIndex'} (default), \code{'GeneName'} and
\code{'Mu'} (mean expression).}

\item{GroupLabel1}{Label assigned to reference group.
Default: \code{GroupLabel1 = 'Group1'}}

\item{GroupLabel2}{Label assigned to reference group.
Default: \code{GroupLabel2 = 'Group2'}}

\item{Plot}{If \code{Plot = TRUE}, MA and volcano plots are generated.}

\item{PlotOffset}{If \code{Plot = TRUE}, the offset effect is visualised.}

\item{PlotOffsetType}{See argument \code{Type} in 
\code{\link{BASiCS_PlotOffset}} for more information.}

\item{Offset}{Optional argument to remove a fix offset effect (if not
previously removed from the MCMC chains). Default: \code{Offset = TRUE}.}

\item{EFDR_M}{Target for expected false discovery rate related to
the comparison of means. If \code{EFDR_M = NULL}, EFDR calibration is not
performed and the posterior probability threshold is set equal to
\code{ProbThresholdM}. Default \code{EFDR_M = 0.05}.}

\item{EFDR_D}{Target for expected false discovery rate related to
the comparison of dispersions. If \code{EFDR_D = NULL}, EFDR calibration is
not performed and the posterior probability threshold is set equal to
\code{ProbThresholdD}.Default \code{EFDR_D = 0.05}.}

\item{EFDR_R}{Target for expected false discovery rate related to
the comparison of residual over-dispersions. If \code{EFDR_R = NULL}, EFDR
calibration is not performed and the posterior probability threshold is set
equal to \code{ProbThresholdR}.Default \code{EFDR_D = 0.05}.}

\item{GenesSelect}{Optional argument to provide a user-defined list
of genes to be considered for the comparison.
Default: \code{GenesSelect = rep(TRUE, nGene)}
When used, this argument must be a vector
of \code{TRUE} (include gene) / \code{FALSE} (exclude gene) indicator,
with the same length as the number of intrinsic genes and following the same
order as how genes are displayed in the table of counts.
This argument is necessary in order to have a meaningful EFDR calibration
when the user decides to exclude some genes from the comparison.}

\item{min.mean}{Minimum mean expression threshold required for inclusion in
offset calculation. Similar to `min.mean` in `scran::computeSumFactors`. This
parameter is only relevant with `Offset = TRUE`.}

\item{MinESS}{The minimum effective sample size for a gene to be included 
in the tests for
differential expression. This helps to remove genes with poor mixing from
differential expression tests.
Default is 100. If set to NA, genes are
not checked for effective sample size before differential expression tests
are performed.}

\item{...}{Optional parameters.}
}
\value{
\code{BASiCS_TestDE} returns an object of class
\code{\linkS4class{BASiCS_ResultsDE}}
}
\description{
Function to assess changes in expression between two groups
of cells (mean and over-dispersion)
}
\examples{

# Loading two 'BASiCS_Chain' objects (obtained using 'BASiCS_MCMC')
data(ChainSC)
data(ChainRNA)

Test <- BASiCS_TestDE(
  Chain1 = ChainSC, Chain2 = ChainRNA,
  GroupLabel1 = "SC", GroupLabel2 = "P&S",
  EpsilonM = log2(1.5), EpsilonD = log2(1.5),
  OffSet = TRUE
)

# Results for the differential mean test
head(as.data.frame(Test, Parameter = "Mean"))

# Results for the differential over-dispersion test
# This only includes genes marked as 'NoDiff' in Test$TableMean
head(as.data.frame(Test, Parameter = "Disp"))

# For testing differences in residual over-dispersion, two chains obtained
# via 'BASiCS_MCMC(Data, N, Thin, Burn, Regression=TRUE)' need to be provided
data(ChainSCReg)
data(ChainRNAReg)

Test <- BASiCS_TestDE(
  Chain1 = ChainSCReg, Chain2 = ChainRNAReg,
  GroupLabel1 = 'SC', GroupLabel2 = 'P&S',
  EpsilonM = log2(1.5), EpsilonD = log2(1.5),
  EpsilonR = log2(1.5)/log2(exp(1)),
  OffSet = TRUE
)

## Plotting the results of these tests
BASiCS_PlotDE(Test)
}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}
}
