% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_MockSCE.R
\name{BASiCS_MockSCE}
\alias{BASiCS_MockSCE}
\title{Create a mock \link[SingleCellExperiment]{SingleCellExperiment-class} object.}
\usage{
BASiCS_MockSCE(
  NGenes = 100,
  NCells = 100,
  NSpikes = 20,
  WithBatch = TRUE,
  MeanMu = 1
)
}
\arguments{
\item{NGenes}{Integer value specifying the number of genes that will be
present in the output.}

\item{NCells}{Integer value specifying the number of cells that will be
present in the output.}

\item{NSpikes}{Integer value specifying the number of spike-in genes that
will be present in the output.}

\item{WithBatch}{Logical value specifying whether a dummy \code{BatchInfo}
is included in the output.}

\item{MeanMu}{The log mean used to generate per-gene mean expression levels.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment-class} object.
}
\description{
Creates a \link[SingleCellExperiment]{SingleCellExperiment-class} object of Poisson-distributed
approximating a homogeneous cell population.
}
\examples{
BASiCS_MockSCE()
}
