% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_Filter.R
\name{BASiCS_Filter}
\alias{BASiCS_Filter}
\title{Filter for input datasets}
\usage{
BASiCS_Filter(
  Counts,
  Tech = rep(FALSE, nrow(Counts)),
  SpikeInput = NULL,
  BatchInfo = NULL,
  MinTotalCountsPerCell = 2,
  MinTotalCountsPerGene = 2,
  MinCellsWithExpression = 2,
  MinAvCountsPerCellsWithExpression = 2
)
}
\arguments{
\item{Counts}{Matrix of dimensions \code{q} times \code{n} whose elements
corresponds to the simulated expression counts.
First \code{q.bio} rows correspond to biological genes. Last \code{q-q.bio}
rows correspond to technical spike-in genes.}

\item{Tech}{Logical vector of length \code{q}. If \code{Tech = FALSE}
the gene is biological; otherwise the gene is spike-in.}

\item{SpikeInput}{Vector of length \code{q-q.bio} whose elements indicate
the simulated input concentrations for the spike-in genes.}

\item{BatchInfo}{Vector of length \code{n} whose elements indicate batch
information. Not required if a single batch is present on the data.
Default: \code{BatchInfo = NULL}.}

\item{MinTotalCountsPerCell}{Minimum value of total expression counts
required per cell (biological and technical).
Default: \code{MinTotalCountsPerCell = 2}.}

\item{MinTotalCountsPerGene}{Minimum value of total expression counts
required per transcript (biological and technical).
Default: \code{MinTotalCountsPerGene = 2}.}

\item{MinCellsWithExpression}{Minimum number of cells where expression
must be detected (positive count). Criteria applied to each transcript.
Default: \code{MinCellsWithExpression = 2}.}

\item{MinAvCountsPerCellsWithExpression}{Minimum average number of
counts per cells where expression is detected. Criteria applied to
each transcript. Default value: \code{MinAvCountsPerCellsWithExpression = 2}.}
}
\value{
A list of 2 elements
\describe{
\item{\code{Counts}}{Filtered matrix of expression counts}
\item{\code{Tech}}{Filtered vector of spike-in indicators}
\item{\code{SpikeInput}}{Filtered vector of spike-in genes input molecules}
\item{\code{BatchInfo}}{Filtered vector of the 'BatchInfo' argument}
\item{\code{IncludeGenes}}{Inclusion indicators for transcripts}
\item{\code{IncludeCells}}{Inclusion indicators for cells}
}
}
\description{
\code{BASiCS_Filter} indicates which transcripts and
cells pass a pre-defined inclusion criteria. The output of this
function used to generate a
\code{\link[SingleCellExperiment]{SingleCellExperiment-class}} object required to run BASiCS.
For more systematic tools for quality control, please refer to the
\code{scater} Bioconductor package.
}
\examples{

set.seed(1)
Counts <- matrix(rpois(50*10, 2), ncol = 10)
rownames(Counts) <- c(paste0('Gene', 1:40), paste0('Spike', 1:10))
Tech <- c(rep(FALSE,40),rep(TRUE,10))
set.seed(2)
SpikeInput <- rgamma(10,1,1)
SpikeInfo <- data.frame('SpikeID' = paste0('Spike', 1:10),
                        'SpikeInput' = SpikeInput)

Filter <- BASiCS_Filter(Counts, Tech, SpikeInput,
                        MinTotalCountsPerCell = 2,
                        MinTotalCountsPerGene = 2,
                        MinCellsWithExpression = 2,
                        MinAvCountsPerCellsWithExpression = 2)
SpikeInfoFilter <- SpikeInfo[SpikeInfo$SpikeID \%in\% rownames(Filter$Counts),]

}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}
}
