% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_DenoisedCounts.R
\name{BASiCS_DenoisedCounts}
\alias{BASiCS_DenoisedCounts}
\title{Calculates denoised expression expression counts}
\usage{
BASiCS_DenoisedCounts(Data, Chain, WithSpikes = TRUE)
}
\arguments{
\item{Data}{An object of class \code{\link[SingleCellExperiment]{SingleCellExperiment-class}}}

\item{Chain}{An object of class \code{\linkS4class{BASiCS_Chain}}}

\item{WithSpikes}{A logical scalar specifying whether denoised spike-in
genes should be generated as part of the output value. This only applies
when the \code{\linkS4class{BASiCS_Chain}} object was generated with
the setting \code{WithSpikes=TRUE}.}
}
\value{
A matrix of denoised expression counts. In line with global scaling
normalisation strategies, these are defined as \eqn{X_{ij}/(\phi_j \nu_j)}
for biological genes and \eqn{X_{ij}/(\nu_j)} for spike-in genes. For this
calculation \eqn{\phi_j} \eqn{\nu_j} are estimated by their corresponding
posterior medians. If spike-ins are not used, \eqn{\phi_j} is set equal to 1.
}
\description{
Calculates denoised expression counts by removing
cell-specific technical variation. The latter includes global-scaling
normalisation and therefore no further normalisation is required.
}
\details{
See vignette \code{browseVignettes("BASiCS")}
}
\examples{

Data <- makeExampleBASiCS_Data(WithSpikes = TRUE)
## The N and Burn parameters used here are optimised for speed
## and should not be used in regular use.
## For more useful parameters,
## see the vignette (\code{browseVignettes("BASiCS")})
Chain <- BASiCS_MCMC(Data, N = 1000, Thin = 10, Burn = 500,
                     Regression = FALSE, PrintProgress = FALSE)

DC <- BASiCS_DenoisedCounts(Data, Chain)

}
\seealso{
\code{\linkS4class{BASiCS_Chain}}
}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}
}
