% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_jaspar.R
\name{read_jaspar}
\alias{read_jaspar}
\title{Import JASPAR motifs.}
\usage{
read_jaspar(file, skip = 0)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}
}
\value{
\code{list} \linkS4class{universalmotif} objects.
}
\description{
Import JASPAR formatted motifs. See \url{http://jaspar.genereg.net/}.
Can be either DNA, RNA, or AA motifs.
}
\examples{
jaspar <- read_jaspar(system.file("extdata", "jaspar.txt",
                                  package = "universalmotif"))

}
\references{
Khan A, Fornes O, Stigliani A, Gheorghe M, Castro-Mondragon JA,
van der Lee R, Bessy A, Cheneby J, Kulkarni SR, Tan G, Baranasic
D, Arenillas DJ, Sandelin A, Vandepoele K, Lenhard B, Ballester B,
Wasserman WW, Parcy F, Mathelier A (2018). “JASPAR 2018: update of
the open-access database of transcription factor binding profiles
and its web framework.” \emph{Nucleic Acids Research}, \strong{46}, D260-D266.
}
\seealso{
Other read_motifs: 
\code{\link{read_cisbp}()},
\code{\link{read_homer}()},
\code{\link{read_matrix}()},
\code{\link{read_meme}()},
\code{\link{read_motifs}()},
\code{\link{read_transfac}()},
\code{\link{read_uniprobe}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
