% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_missing_abundance.R
\docType{methods}
\name{fill_missing_abundance}
\alias{fill_missing_abundance}
\title{Fill transcript abundance if missing from sample-transcript pairs}
\usage{
fill_missing_abundance(
  .data,
  .sample = NULL,
  .transcript = NULL,
  .abundance = NULL,
  fill_with
)
}
\arguments{
\item{.data}{A `tbl` formatted as | <SAMPLE> | <TRANSCRIPT> | <COUNT>  | <...> |}

\item{.sample}{The name of the sample column}

\item{.transcript}{The name of the transcript column}

\item{.abundance}{The name of the transcript abundance column}

\item{fill_with}{A numerical abundance with which fill the missing data points}
}
\value{
A consistent object (to the input) non-sparse abundance
}
\description{
fill_missing_abundance() takes as input A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment)) and returns a consistent object (to the input) with new observations
}
\details{
\lifecycle{questioning}

This function fills the abundance of missing sample-transcript pair using the median of the sample group defined by the formula
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex



print("Not run for build time.")

# airway |>  fill_missing_abundance( fill_with = 0)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7
}
