% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_srsc.R
\name{norm_srsc}
\alias{norm_srsc}
\title{Jointly normalization of spatially resolved single cell data and bulk data}
\usage{
norm_srsc(cell, assay, bulk)
}
\arguments{
\item{cell}{A \code{Seurat} object.}

\item{assay}{The assay to use for normalization in the spatial single-cell data.}

\item{bulk}{The bulk assay data.}
}
\description{
Jointly normalization of spatially resolved single cell data and bulk data
}
\examples{
library(Seurat); library(SummarizedExperiment)
# Bulk data. 
blk.mus <- readRDS(system.file("extdata/shinyApp/data", "bulk_mouse_cocluster.rds", package="spatialHeatmap"))
assay(blk.mus)[1:3, 1:5] 
# Spatial single-cell data.
# library(SeuratData)
# if (!'stxBrain' \%in\% InstalledData()$Dataset) InstallData("stxBrain")
# brain <- LoadData("stxBrain", type = "anterior1") 
# Joint normalization. 
# nor.lis <- norm_srsc(cell=brain, assay='Spatial', bulk=blk.mus) 
# Separate bulk and cell data. 
# srt.sc <- nor.lis$cell; bulk <- nor.lis$bulk 
}
\references{
Hao and Hao et al. Integrated analysis of multimodal single-cell data. Cell (2021) [Seurat V4]
Stuart and Butler et al. Comprehensive Integration of Single-Cell Data. Cell (2019) [Seurat V3]
Butler et al. Integrating single-cell transcriptomic data across different conditions, technologies, and species. Nat Biotechnol (2018) [Seurat V2]
Satija and Farrell et al. Spatial reconstruction of single-cell gene expression data. Nat Biotechnol (2015) [Seurat V1]
Pagès H, Lawrence M, Aboyoun P (2022). _S4Vectors: Foundation of vector-like and list-like containers in Bioconductor_. R package version 0.36.1, <https://bioconductor.org/packages/S4Vectors>.
Morgan M, Obenchain V, Hester J, Pagès H (2021). SummarizedExperiment: SummarizedExperiment container. R package version 1.24.  0, https://bioconductor.org/packages/SummarizedExperiment.
Amezquita R, Lun A, Becht E, Carey V, Carpp L, Geistlinger L, Marini F, Rue-Albrecht K, Risso D, Soneson C, Waldron L, Pages H, Smith M, Huber W, Morgan M, Gottardo R, Hicks S (2020). “Orchestrating single-cell analysis with Bioconductor.” _Nature Methods_, *17*, 137-145. <https://www.nature.com/articles/s41592-019-0654-x>.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
