% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTopResults.R
\name{plotTopResults}
\alias{plotTopResults}
\title{Plot the most significant findings for a certain PI}
\usage{
plotTopResults(
  hypFrame,
  results,
  pi,
  effect = "Intercept",
  what = if (pi \%in\% c("nn", "nnCell")) {
     "aggregated"
 } else if (pi \%in\%
    c("nnPair", "nnPairCell")) {
     "colocalized"
 } else if (pi \%in\% c("edge",
    "centroid")) {
     "close"
 },
  sigLevel = 0.05,
  numFeats = 2,
  piThreshold = switch(effect, Intercept = 0.5, 0),
  effectParameter = NULL,
  ...
)
}
\arguments{
\item{hypFrame}{The hyperframe with the data}

\item{results}{The results frame}

\item{pi}{A character string, specifying the probabilistic index}

\item{effect}{The name of the effect}

\item{what}{Which features should be detected? Can be abbreviated, see details.}

\item{sigLevel}{The significance level}

\item{numFeats}{The number of features to plot}

\item{piThreshold}{The threshold for PI, a minimum effect size}

\item{effectParameter}{A character string, indicating which parameter to look
for when effect is provided}

\item{...}{passed onto plotting functions plotCells or plotExplore}
}
\value{
A plot from plotCells or plotExplore, throws an error when no features meet the criteria
}
\description{
Extract the most significant features for a certain PI and direction of effect,
and plot them using an appropriate function: either \link{plotExplore} or
\link{plotCells}
}
\details{
The "what" argument indicates if features far from or close to
cell wall or centroid should be shown for pi "edge" or "centroid",
aggregated or regular features for "nn" and "nnCell" and colocalized or
antilocalized features for "nnPair" and "nnPairCell". Partial matching is allowed.
Defaults to small probabilistic indices: proximity, aggregation and colocalization.
For fixed effects, provide the name of the parameter, in combination with what. For instance,
what = "regular", effect = "Var1" and effectParameter = "level1" will return
features more regular at level1 of the variable than at baseline.
}
\examples{
example(fitLMMs, "smoppix")
plotTopResults(hypYang, lmmModels, "nn")
#For the sake of illustration, set high significance level, as example dataset is small
plotTopResults(hypYang, lmmModels, "nn",
    effect = "day", what = "reg",
    effectParameter = "day0", sigLevel = 1-1e-10)
}
\seealso{
\link{plotCells},\link{plotExplore},\link{fitLMMs}
}
