% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estPis.R, R/addWeightFunction.R
\name{estPis}
\alias{estPis}
\alias{estPisSingle}
\alias{addWeightFunction}
\title{Estimate probabilistic indices and add a variance weighting function.}
\usage{
estPis(
  hypFrame,
  pis = c("nn", "nnPair", "edge", "centroid", "nnCell", "nnPairCell"),
  verbose = TRUE,
  null = c("background", "CSR"),
  nPointsAll = switch(null, background = 50000, CSR = 2000),
  nPointsAllWithinCell = switch(null, background = 5000, CSR = 1000),
  nPointsAllWin = 10000,
  minDiff = 20,
  minObsNN = 1L,
  features = getFeatures(hypFrame),
  ...
)

estPisSingle(
  p,
  pis,
  null,
  tabObs,
  owins = NULL,
  centroids = NULL,
  window = p$window,
  loopFun = "bplapply",
  features,
  nPointsAll,
  nPointsAllWithinCell,
  nPointsAllWin,
  minDiff,
  minObsNN
)

addWeightFunction(
  resList,
  pis = resList$pis,
  designVars,
  lowestLevelVar,
  maxObs = 1e+05,
  maxFeatures = 1000,
  minNumVar = 3,
  ...
)
}
\arguments{
\item{hypFrame}{A hyperframe}

\item{pis}{The PIs to be estimated or for which weighting functions is to be added}

\item{verbose}{A boolean, whether to report on progress of the fitting process.}

\item{null}{A character vector, indicating how the null distribution is
defined. See details.}

\item{nPointsAll, nPointsAllWithinCell}{How many points to subsample or simulate to calculate the
overall nearest neighbour distance distribution under the null hypothesis.
The second argument (nPointsAllWithinCell) applies to within cell calculations, where a lower number usually suffises.}

\item{nPointsAllWin}{How many points to subsample or simulate
to calculate distance to cell edge or centroid distribution}

\item{minDiff}{An integer, the minimum number of events from other genes
needed for calculation of background distribution of distances.
Matters mainly for within-cell calculations: cells with too few events are skipped.}

\item{minObsNN}{An integer, the minimum number of events required for a gene to be analysed. See details.}

\item{features}{A character vector, for which features should the
probabilistic indices be calculated?}

\item{...}{Additional arguments passed on to the \link[scam]{scam} function, fitting the spline}

\item{p}{The point pattern}

\item{tabObs}{A table of observed gene frequencies}

\item{owins, centroids}{The list of windows corresponding to cells,
and their centroids}

\item{window}{An window of class owin, in which events can occur}

\item{loopFun}{The function to use to loop over the features.
Defaults to bplapply except when looping over features within cells}

\item{resList}{A results list, from a call to estPis().}

\item{designVars}{A character vector containing all design factors
(both fixed and random), that are also present as variables in hypFrame.}

\item{lowestLevelVar}{The design variable at the lowest level of nesting,
often separating technical replicates. The conditional variance is calculated
within the groups of PIs defined by this variable.}

\item{maxObs, maxFeatures}{The maximum number of observations respectively
features for fitting the weighting function. See details.}

\item{minNumVar}{The minimum number of observations needed to calculate a
variance. Groups with fewer replicates are ignored.}
}
\value{
For estPis(), the hyperframe with the estimated PIs present in it

For estPisSingle(), a list of data frames with estimated PIs per gene and/or gene pair:
\item{pointDists}{PIs for pointwise distances overall}
\item{windowDists}{PIs for distances to cell wall or centroid}
\item{withinCellDists}{PIs for pointwise distances within cell}

For addWeightFunction(), the input object 'resList' with a slot 'Wfs' added containing the weighting
functions.
}
\description{
Estimate different probabilistic indices for localization
on all point patterns of a hyperframe, and integrate the results in the same hyperframe. 
estPisSingle() is the workhorse function for a single point pattern.

addWeightFunction() adds a weighting function based on the data to the object by modeling variance as a
non-increasing spline as a function of the number of events.
}
\details{
The null distribution used to calculate the PIs can be either 'background' or 'null'.
For 'background', the observed distributions of all genes is used. Alternatively,
for null = 'CSR', Monte-Carlo simulation under complete spatial randomness
is performed within the given window to find the null distribution of the distance under study.
See \insertCite{Hawinkel2025b;nobrackets}{smoppix} for precise definition of the PI.

The 'nn' prefix indicates that nearest neighbour distances are being used,
either univariately or bivariately.
The suffix 'Pair' indicates that bivariate probabilistic indices,
testing for co- and antilocalization are being used.
'edge' and 'centroid' calculate the distance to the edge respectively
 the centroid of the windows added using the \link{addCell} function.
The suffix 'Cell' indicates that nearest neighbour distances are being calculated within cells only.

It can be useful to set the minObsNN higher than the default of 5 for calculations within cells when the number of events is low,
not to waste computation time on gene (pairs) with very variable PI estimates.

Provide either 'designVars' or 'lowestLevelVar'. The 'designVars' are 
usually the same as the regressors in the linear model. In case 'lowestLevelVar' is provided, the
design variables are set to all imageVars in the hypFrame object except
lowestLevelVar. When the PI is calculated on the cell level ("nnCell" or "nnPairCell"),
the cell is always the lowest nesting level, and inputs to 'designVars' or 'lowestLevelVar' will be ignored for these PIs.
The registered parallel backend will be used for fitting the trends of the
different PIs.
For computational and memory reasons, for large datasets the trend fitting
is restricted to a random subset of the data through the maxObs and
maxFeatures parameters.
}
\examples{
data(Yang)
hypYang <- buildHyperFrame(Yang,
    coordVars = c("x", "y"),
    imageVars = c("day", "root", "section")
)
yangPims <- estPis(hypYang[c(seq_len(4), seq(27, 29)), ], pis = "nn",
    nPointsAll = 4e2)
# Univariate nearest neighbour distances
yangObj <- addWeightFunction(yangPims, designVars = c("day", "root")) 
# Add the weight functions 
yangObj <- addWeightFunction(yangPims, lowestLevelVar = "section", 
pi = "nn")
# Alternative formulation with 'lowestLevelVar'
}
\references{
\insertAllCited{}
}
\seealso{
\link{buildDataFrame}, \link{estPis}
}
